/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.UnionInfoResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version UnionInfoParam.java, v 0.1 2020-04-22 16:28
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UnionInfoRequest extends VbillBizRequest<UnionInfoResponse> {

    private static final long serialVersionUID = -3179669698580892288L;
    /**
     * 商编
     */
    @NotBlank
    private String mno;

    /**
     * 授权码
     */
    @NotBlank
    private String userAuthCode;

    /**
     * 银联支付标识 格式为“UnionPay/版本号 App标识>”(不含双引号;注意版本号与App标识中间有一个英文空格)，
     * 其中<版本号>使用 1.0(后续版本由银联按需定义)， <App 标识>为付款方自行定义内容 (仅包含字母或数字)。
     * 银联支付标识需要收款方通过 HTTP 中的 User Agent 截取，注意从前往后截取，
     * 版本号获取：匹配“UnionPay/” 作为开始，至英文空格之间的内容为版本号(如 1.0、1.1、2.0)
     * App标识获取：从英文空格开始，至非字母非数字结束，之间的内容为每一个APP的特殊标识。
     * APP的特殊标识用来建立用户标识(userId，在特定APP下唯一)和APP的对应关系。
     * 收款方仅需识别 “UnionPay/”(而不用完整的银联支付标识)就可以确定为银联JS支付。
     */
    @NotBlank
    private String paymentApp;

    @Override
    public Class<UnionInfoResponse> getResponseClass() {
        return UnionInfoResponse.class;
    }
}