/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author yangdw
 * @version DishesPropertiesModel.java, v 0.1 2020-04-27 18:34
 */
@Data
public class DishesPropertiesRequest implements Serializable {

    private static final long serialVersionUID = -9146638483332551570L;
    /**
     * 商编
     */
    @NotBlank
    private String mno;

    /**
     * 口味
     * 辣
     */
    private String taste;

    /**
     * 做法
     * 炒
     */
    private String cuisine;

    /**
     * 主料，以竖线(|)分隔
     */
    private String mainMaterial;

    /**
     * 配料，以竖线(|)分隔
     * 青椒|辣椒|葱|八角
     */
    private String ingredients;

    /**
     * 其他，以竖线(|)分隔
     * 有机|农家
     */
    private String others;
}   