/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 商户入驻/进件相关API
 *
 * @author Liluqing
 * @version VbillMerchantApiEnum.java, v 0.1 2020-06-08 16:11
 */
public enum VbillMerchantApiEnum implements VbillBaseApi {
    /**
     * 枚举列表
     */
    /**
     * 入驻结果查询
     */
    MERCHANT_QUERY_MERCHANT_INFO("入驻结果查询", "/merchant/queryMerchantInfo"),
    /**
     * 商户修改结果查询
     */
    MERCHANT_QUERY_MODIFY_RESULT("商户修改结果查询", "/merchant/queryModifyResult"),
    /**
     * 微信子商户支付参数查询
     */
    MERCHANT_WECHAT_PAY_SET_QUERY_CONFIG("微信子商户支付参数查询", "/merchant/weChatPaySet/queryConf"),
    /**
     * 微信子商户支付参数配置
     */
    MERCHANT_WECHAT_PAY_SET_ADD_CONFIG("微信子商户支付参数配置", "/merchant/weChatPaySet/addConf"),
    /**
     * 商户进件
     */
    MERCHANT_INCOME("商户进件", "/merchant/income"),
    /**
     * 商户信息查询
     */
    MERCHANT_INFO_QUERY("商户信息查询", "/merchant/merchantInfoQuery"),
    /**
     * 商户设置
     */
    MERCHANT_SETUP("商户设置", "/merchant/merchantSetup"),
    /**
     * 修改商户信息
     */
    MERCHANT_EDIT_INFO("修改商户信息", "/merchant/editMerchantInfo");

    private String name;
    private String value;

    VbillMerchantApiEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    @Override
    public String getApiSubPath() {
        return value;
    }

    @Override
    public String getApiURL(String basePath) {
        return basePath + value;
    }

    public static VbillMerchantApiEnum getByValue(String value) {
        VbillMerchantApiEnum[] valueList = VbillMerchantApiEnum.values();
        for (VbillMerchantApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}