/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.payment;

import com.fshows.vbill.sdk.response.VbillBizResponse;
import lombok.Data;

/**
 * @author Liluqing
 * @version VbillJsPayResponse.java, v 0.1 2020-06-09 15:45
 */
@Data
public class VbillJsPayResponse extends VbillBizResponse {

    /**
     * 商户订单号
     */
    private String ordNo;

    /**
     * 随行付订单号
     */
    private String uuid;

    /**
     * 微信预下单 id
     */
    private String prepayId;

    /**
     * 微信 appId
     */
    private String payAppId;

    /**
     * 微信 timeStamp
     */
    private String payTimeStamp;

    /**
     * 微信 timeStamp
     */
    private String paynonceStr;

    /**
     * 微信 package
     */
    private String payPackage;

    /**
     * 微信 signType
     */
    private String paySignType;


    /**
     * 微信 sign
     */
    private String paySign;

    /**
     * 微信 partnerid
     */
    private String partnerId;

    /**
     * 银联定向跳转地址
     */
    private String redirectUrl;

    /**
     * 支付宝渠道可选上送，该参数是支付宝分配给下游的识别号，2088 开头的一串 16 位数字 ；微信渠道不需要该参数。
     */
    private String source;
}