/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.other;

import com.fshows.vbill.sdk.response.VbillBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author yangdw
 * @version TransferAccountsQueryResponse.java, v 0.1 2020-04-27 20:36
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TransferAccountsQueryResponse extends VbillBizResponse {

    /**
     * 随行付转账订单号
     */
    private String tranNo;

    /**
     * 转账状态; 00: 成功,01:失败,02:异常
     */
    private String tranStatus;

    /**
     * 转账金额;单位元，保留两位小数
     */
    private String amount;

    /**
     * 转账服务费; 单位元，保留 两位小数
     */
    private String rate;

    /**
     * 服务费出资方
     * 01:服务商出资; 02:商户出资
     */
    private String investor;

    /**
     * 成功时间
     */
    private String transferTime;

    /**
     * 备注
     */
    private String content;
}   