/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.payment;


import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.payment.VbillQrCodeOrderResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author xiaotian
 * @version QrCodeOrderParam.java, v 0.1 2020-04-22 10:22
 */
@Data
public class VbillQrCodeOrderRequest extends VbillBizRequest<VbillQrCodeOrderResponse> implements Serializable {

    private static final long serialVersionUID = 480779796476544243L;

    /**
     * 随行付商编
     */
    private String mno;
    /**
     * 外部订单号
     */
    private String ordNo;

    /**
     * 子商户号
     */
    private String subMechId;

    /**
     * 微信的subappid
     */
    private String subAppid;

    /**
     * 订单金额
     */
    private String amt;

    /**
     * 折扣金额
     */
    private String discountAmt;

    /**
     * 参与优惠金额
     */
    private String unDiscountAmt;

    /**
     * WECHAT ALIPAY UNIONPAY
     */
    private String payType;

    /**
     * 订单标题
     */
    private String subject;

    /**
     * 服务商 01 收银台 02 硬件 03
     */
    private String tradeSource;

    /**
     * 交易 ip 地址
     */
    private String trmIp;

    /**
     * 花呗分期数
     */
    private String hbFqNum;

    /**
     * 卖家承担分期
     * 服务费比例；
     * 不上送默认由
     * 买家承担
     */
    private String hbFqPercent;

    /**
     * 限制卡类型
     */
    private String limitPay;

    /**
     * 订单失效时间
     */
    private String timeExpire;

    /**
     * 订单优惠标识00 ：是， 01 ：否；目前仅支持微信；
     * 交易渠道为支付宝、银联时上送该参数则返回错误
     */
    private String goodsTag;

    /**
     * 微信优惠参数
     */
    private String wxGoodsTag;

    /**
     * 优惠详情信息
     */
    private String couponDetail;

    /**
     * 电子发票功能微信开具电子发票使用；目前仅支持微信；交易渠道为支付宝、银联时上送该参数则返回错误
     * 00:是，01:否
     */
    private String needReceipt;

    /**
     * 是否做分账分账交易使用；
     * 00：做；01：不做；不传默认为不做分账
     */
    private String ledgerAccountFlag;

    /**
     * 分账有效时间单位为天；是否做分账选择 00 时该字段必传；
     * 最大支持上送：30；注：从发起交易日期记为 1
     */
    private String ledgerAccountEffectTime;

    /**
     * 接收支付结果通知地址
     */
    private String notifyUrl;

    /**
     * 银联终端号
     */
    private String ylTrmNo;

    /**
     * TQ 机具编号，支付来源为硬件时，该参数为必传；
     */
    private String terminalId;

    /**
     * 设备号
     */
    private String deviceNo;

    /**
     * 是否实名支付：00：是，01：否 不传默认为01;00 时；
     * 买家姓名、证件类型、证件号为必填
     */
    private String identityFlag;

    /**
     * 证 件 类 型 : 大陆：IDCARD；目前仅支持大陆证件号
     */
    private String buyerIdType;

    /**
     * 证件号:证件号只允许等于18位
     */
    private String buyerIdNo;

    /**
     * 买家姓名
     */
    private String buyerName;

    /**
     * 手机号
     */
    private String mobileNum;

    /**
     * 手机号
     */
    private String extend;


    @Override
    public Class getResponseClass() {
        return VbillQrCodeOrderResponse.class;
    }
}

