/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author yangdw
 * @version WechatQrorderInfoModel.java, v 0.1 2020-04-27 18:17
 */
@Data
public class WechatDishesInfoRequest implements Serializable {

    private static final long serialVersionUID = -9130200758702872790L;
    /**
     * 商编
     */
    @NotBlank
    private String mno;

    /**
     * 商户菜品ID
     */
    private String outDishNo;

    /**
     * 菜品名称
     */
    private String name;

    /**
     * 菜品单价，单位为元
     */
    private String orderPrice;

    /**
     * 菜品单位，BY_SHARE:按份 BY_WEIGHT:按重量
     */
    private String unit;

    /**
     * 菜品数量，保留小数点后2位有效数字
     * 1.50
     */
    private String orderCount;

    /**
     * 菜品分类，详见参数规定《菜品类型列表》
     * FAST_FOOD
     */
    private String type;

    /**
     * 当前菜品在服务商平台的顺序，值越小越靠前，取值(1~100)
     */
    private String orderPriority;

    /**
     * 详见参数规定《菜品属性列表》
     */
    private DishesPropertiesRequest properties;

}   