/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author youmingming
 * @version VbillCounterofferApiEnum.java, v 0.1 2020-06-15 1:31 下午 youmingming
 */
public enum VbillAccountApiEnum implements VbillBaseApi {
    /**
     * 结算数据查询接口
     */
    CAPITAL_QUERY_QUERYSETTLEMENT("结算查询接口", "/capital/query/querySettlement"),
    CAPITAL_QUERY_QUERYBALANCE("账户余额接口", "/capital/query/queryBalance"),
    CAPITAL_FILEDOWNLOAD_GETFILEURL("对账单下载接口", "/capital/fileDownload/getFileUrl");

    private String name;
    private String value;

    VbillAccountApiEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static VbillAccountApiEnum getByValue(String value) {
        VbillAccountApiEnum[] valueList = VbillAccountApiEnum.values();
        for (VbillAccountApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    @Override
    public String getApiSubPath() {
        return value;
    }

    @Override
    public String getApiURL(String basePath) {
        return basePath + value;
    }
}