/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.umpay.bankchannel.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.umpay.annotation.EncryptField;
import com.fshows.umpay.bankchannel.client.UmBankClient;
import com.fshows.umpay.bankchannel.request.UmBankBizItemRequest;
import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.UmBankBaseResponse;
import com.fshows.umpay.bankchannel.response.UmBankLinkResponse;
import com.fshows.umpay.bankchannel.response.UmBankMetaResponse;
import com.fshows.umpay.bankchannel.util.UmFileClinet;
import com.fshows.umpay.bankchannel.util.UmHttpClient;
import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.exception.UmPayException;
import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.util.SignUtil;
import com.fshows.umpay.sdk.util.ValidateUtil;
import com.umpay.mer.ConfigContext;
import com.umpay.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmBankClientImpl
implements UmBankClient {
    private static final Logger log = LoggerFactory.getLogger(UmBankClientImpl.class);
    private static final String VERSION = "1.0";
    private String appId;
    private String fbPrivateKey;
    private String umPublicKey;
    private static Map<Class<?>, List<Field>> encryptionMap = new ConcurrentHashMap();
    private static SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();

    public UmBankClientImpl(String appId, String fbPrivateKey, String umPublicKey) {
        this.appId = appId;
        this.fbPrivateKey = fbPrivateKey;
        this.umPublicKey = umPublicKey;
    }

    @Override
    public <R> UmBankBaseResponse<R> excute(UmBankBizRequest<R> request, UmpayApiDefinition umpayApiDefinition, String postUrl) throws UmPayException {
        return this.excute(request, umpayApiDefinition, postUrl, this.appId);
    }

    @Override
    public <R> UmBankBaseResponse<R> excute(UmBankBizRequest<R> request, UmpayApiDefinition umpayApiDefinition, String postUrl, String subAppId) throws UmPayException {
        String method = umpayApiDefinition.getMethod();
        this.validateParam(request, method);
        if (StringUtils.isBlank((CharSequence)request.getMerId())) {
            request.setMerId(this.appId);
        }
        if (StringUtils.isBlank((CharSequence)request.getVersion())) {
            request.setVersion(VERSION);
        }
        String apiURL = postUrl + umpayApiDefinition.getMethod();
        long startTime = System.currentTimeMillis();
        log.info("\u3010umpay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5f00\u59cb >> url={}, request={}", (Object)apiURL, (Object)JSON.toJSONString(request, (SerializeConfig)SNAKE_CASE_CONFIG, (SerializerFeature[])new SerializerFeature[0]));
        try {
            this.encryptFiled(request);
            String body = this.getRequestData(request, method, this.appId);
            ConfigContext apicontext = new ConfigContext(apiURL, this.appId);
            Map<String, Object> result = UmHttpClient.post(apicontext, body, this.fbPrivateKey);
            log.info("\u3010umpay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u7ed3\u675f >> url={},request={},response={},cost={}", new Object[]{apiURL, body, result.get("data"), System.currentTimeMillis() - startTime});
            UmBankClientImpl.checkHttpCodeSuccess(result);
            String data = (String)result.get("data");
            return this.parseResponse(data, request);
        }
        catch (Exception ex) {
            log.error("\u3010umpay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5931\u8d25 >> url={},method={},request={},ex={},cost={}", new Object[]{postUrl, method, JSON.toJSONString(request, (SerializeConfig)SNAKE_CASE_CONFIG, (SerializerFeature[])new SerializerFeature[0]), ExceptionUtils.getStackTrace((Throwable)ex), System.currentTimeMillis() - startTime});
            throw new UmPayException(ex.getMessage());
        }
    }

    @Override
    public <R> UmBankBaseResponse<R> uploadFile(UmBankBizRequest<R> request, UmpayApiDefinition umpayApiDefinition, File file, String postUrl, String subAppId) throws UmPayException {
        String method = umpayApiDefinition.getMethod();
        this.validateParam(request, method);
        if (StringUtils.isBlank((CharSequence)request.getMerId())) {
            request.setMerId(this.appId);
        }
        String apiURL = postUrl + umpayApiDefinition.getMethod();
        long startTime = System.currentTimeMillis();
        log.info("\u3010umpay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5f00\u59cb >> url={}, request={}, file={}", new Object[]{apiURL, JSON.toJSONString(request, (SerializeConfig)SNAKE_CASE_CONFIG, (SerializerFeature[])new SerializerFeature[0]), file.getName()});
        try {
            this.encryptFiled(request);
            String body = this.getRequestData(request, method, this.appId);
            ConfigContext apicontext = new ConfigContext(apiURL, this.appId);
            Map<String, Object> result = UmFileClinet.post(apicontext, body, file, this.fbPrivateKey);
            log.info("\u3010umpay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u7ed3\u675f >> url={},request={},file={}, response={},cost={}", new Object[]{apiURL, body, file.getName(), result.get("data"), System.currentTimeMillis() - startTime});
            UmBankClientImpl.checkHttpCodeSuccess(result);
            String data = (String)result.get("data");
            return this.parseResponse(data, request);
        }
        catch (Exception ex) {
            log.error("\u3010umpay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5931\u8d25 >> url={},method={},request={},ex={},cost={}", new Object[]{postUrl, method, JSON.toJSONString(request, (SerializeConfig)SNAKE_CASE_CONFIG, (SerializerFeature[])new SerializerFeature[0]), ExceptionUtils.getStackTrace((Throwable)ex), System.currentTimeMillis() - startTime});
            throw new UmPayException(ex.getMessage());
        }
    }

    @Override
    public <R> InputStream downloadFile(UmBankBizRequest<R> request, UmpayApiDefinition umpayApiDefinition, String getUrl) throws UmPayException {
        String method = umpayApiDefinition.getMethod();
        this.validateParam(request, method);
        if (StringUtils.isBlank((CharSequence)request.getMerId())) {
            request.setMerId(this.appId);
        }
        if (StringUtils.isBlank((CharSequence)request.getVersion())) {
            request.setVersion(VERSION);
        }
        String apiURL = getUrl + umpayApiDefinition.getMethod();
        long startTime = System.currentTimeMillis();
        log.info("\u3010umpay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5f00\u59cb >> url={}, request={}", (Object)apiURL, (Object)JSON.toJSONString(request, (SerializeConfig)SNAKE_CASE_CONFIG, (SerializerFeature[])new SerializerFeature[0]));
        try {
            this.encryptFiled(request);
            ConfigContext apicontext = new ConfigContext(apiURL, this.appId);
            HashMap<String, String> reqMap = new HashMap<String, String>(16);
            for (Field field : request.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                String finalFieldName = fieldName.replaceAll("([A-Z])", "_$1").toLowerCase();
                String value = field.get(request).toString();
                reqMap.put(finalFieldName, value);
            }
            InputStream inputStream = UmHttpClient.downloadFile(apicontext, reqMap, this.fbPrivateKey);
            log.info("\u3010umpay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u7ed3\u675f >> url={},request={},response={},cost={}", new Object[]{apiURL, reqMap, inputStream, System.currentTimeMillis() - startTime});
            return inputStream;
        }
        catch (Exception ex) {
            log.error("\u3010umpay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5931\u8d25 >> url={},method={},request={},ex={},cost={}", new Object[]{getUrl, method, JSON.toJSONString(request, (SerializeConfig)SNAKE_CASE_CONFIG, (SerializerFeature[])new SerializerFeature[0]), ExceptionUtils.getStackTrace((Throwable)ex), System.currentTimeMillis() - startTime});
            throw new UmPayException(ex.getMessage());
        }
    }

    private static void checkHttpCodeSuccess(Map<String, Object> resMap) {
        if (resMap != null && resMap.size() != 0) {
            int statusCode = (Integer)resMap.get("statusCode");
            if (statusCode != 200) {
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
        } else {
            throw new RuntimeException("Connection refused: connect");
        }
    }

    private <R> void validateParam(UmBizRequest<R> request, String method) {
        if (request == null) {
            throw new IllegalArgumentException("\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.fbPrivateKey)) {
            throw new IllegalArgumentException("\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.umPublicKey)) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)method)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ValidateUtil.validateWithThrow(request, new Class[0]);
    }

    private <R> String getRequestData(UmBizRequest<R> request, String method, String appId) {
        return JSON.toJSONString(request, (SerializeConfig)SNAKE_CASE_CONFIG, (SerializerFeature[])new SerializerFeature[0]);
    }

    private void encryptFiled(Object request) throws Exception {
        List<Field> fieldList = this.initEncryptFiledMap(request.getClass());
        for (Field field : fieldList) {
            Object value = field.get(request);
            if (value instanceof String) {
                String encryptValue = this.encrypt((String)value);
                field.set(request, encryptValue);
                continue;
            }
            if (!(value instanceof UmBankBizItemRequest)) continue;
            this.encryptFiled(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Field> initEncryptFiledMap(Class<?> clazz) {
        List<Field> fieldList = encryptionMap.get(clazz);
        if (fieldList != null) return fieldList;
        Class<UmBankClientImpl> clazz2 = UmBankClientImpl.class;
        synchronized (UmBankClientImpl.class) {
            fieldList = encryptionMap.get(clazz);
            if (fieldList != null) return fieldList;
            fieldList = new ArrayList<Field>();
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(EncryptField.class)) continue;
                field.setAccessible(true);
                fieldList.add(field);
                encryptionMap.put(clazz, fieldList);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return fieldList;
        }
    }

    private String encrypt(String value) throws Exception {
        PublicKey pubKey = SignUtil.getPublicKeyFromX509("RSA", new ByteArrayInputStream(this.umPublicKey.getBytes()));
        Cipher cipher = Cipher.getInstance(KeyFactory.getInstance("RSA").getAlgorithm());
        cipher.init(1, pubKey);
        String str = new String(Base64.encode((byte[])cipher.doFinal(value.getBytes("UTF-8")))).replace("\n", "");
        return str;
    }

    private <R> UmBankBaseResponse<R> parseResponse(String result, UmBizRequest<R> request) {
        JSONArray jsonArray;
        JSONObject resultJson = JSON.parseObject((String)result);
        UmBankMetaResponse metaResponse = (UmBankMetaResponse)resultJson.getObject("meta", UmBankMetaResponse.class);
        UmBankBaseResponse<Object> response = new UmBankBaseResponse<Object>();
        if (metaResponse != null) {
            response.setRetCode(metaResponse.getRetCode());
            response.setRetMsg(metaResponse.getRetMsg());
        } else {
            response.setRetCode("9999");
            response.setRetMsg("\u8054\u52a8\u8fd4\u56de\u7a7a\u54cd\u5e94\u7ed3\u679c");
        }
        if (resultJson.containsKey((Object)"data")) {
            response.setData(JSON.parseObject((String)resultJson.getString("data"), request.getResponseClass()));
        }
        if ((jsonArray = resultJson.getJSONArray("links")) != null && jsonArray.size() > 0) {
            response.setLinks(jsonArray.toJavaList(UmBankLinkResponse.class));
        }
        return response;
    }

    static {
        UmBankClientImpl.SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

