/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.umpay.bankchannel.util;

import com.fshows.umpay.sdk.util.SignUtil;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.umpay.mer.ConfigContext;
import com.umpay.util.StringUtils;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmHttpClient {
    private static final Logger log = LoggerFactory.getLogger(UmHttpClient.class);
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_TEXT_JSON = "text/json";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CHARSET = "UTF-8";
    public static final String HEADER = "header";
    public static final String DATA = "data";
    public static final String RULE = "spay";
    public static final String STATUSCODE = "statusCode";
    public static final int STATUS_200 = 200;
    public static final int STATUS_302 = 302;
    public static int CONNECTTIMEOUT = 6000;
    public static int SOCKETTIMEOUT = 120000;

    public static Map<String, Object> get(ConfigContext apicontext, Map<String, String> reqMap, String fbPrivateKey) throws Exception {
        String plain = UmHttpClient.getPlain(reqMap);
        String plainEncode = UmHttpClient.getPlainEncode(reqMap);
        String url = apicontext.getUrl();
        String merId = apicontext.getMerId();
        String charset = apicontext.getCharset();
        if (charset == null || "".equals(charset)) {
            charset = CHARSET;
        }
        String sign = SignUtil.sign(plain, "RSA", fbPrivateKey);
        log.info(String.format("\u7b7e\u540d\uff1a%s", sign));
        return UmHttpClient.get(url + "?" + plainEncode, sign, charset);
    }

    public static Map<String, Object> post(ConfigContext apicontext, String body, String fbPrivateKey) throws Exception {
        String url = apicontext.getUrl();
        String merId = apicontext.getMerId();
        String rsaCharset = apicontext.getCharset();
        if (rsaCharset == null || "".equals(rsaCharset)) {
            rsaCharset = CHARSET;
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        String sign = SignUtil.sign(body, "RSA", fbPrivateKey);
        return UmHttpClient.post(url, body, sign, rsaCharset);
    }

    public static Map<String, Object> get(String url, String charset, Map<String, String> reqMap) throws Exception {
        String plain = UmHttpClient.getPlainEncode(reqMap);
        if (charset == null || "".equals(charset)) {
            charset = CHARSET;
        }
        return UmHttpClient.get(url + "?" + plain, (String)null, charset);
    }

    public static <T> Map<String, Object> post(String url, T t, String charset) throws Exception {
        Gson gson = new Gson();
        String body = gson.toJson(t);
        return UmHttpClient.post(url, body, null, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> post(String url, String json, String sign, String charset) throws Exception {
        if (StringUtils.isEmpty((String)url)) {
            throw new RuntimeException("HttpClient,error url:" + url);
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(CONNECTTIMEOUT).setSocketTimeout(SOCKETTIMEOUT).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        if (StringUtils.isEmpty((String)charset)) {
            charset = CHARSET;
        }
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader(CONTENT_TYPE, CONTENT_TYPE_JSON);
        if (sign != null && !"".equals(sign.trim())) {
            httpPost.setHeader("Signature", sign);
        }
        StringEntity se = new StringEntity(json, charset);
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (CloseableHttpResponse response = null;){
            se.setContentType(CONTENT_TYPE_TEXT_JSON);
            se.setContentEncoding((Header)new BasicHeader(CONTENT_TYPE, CONTENT_TYPE_JSON));
            httpPost.setEntity((HttpEntity)se);
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            String result = null;
            if (statusCode != 200) {
                if (statusCode != 302) {
                    httpPost.abort();
                    throw new RuntimeException("HttpClient,error status code :" + statusCode);
                }
                result = response.getHeaders("location")[0].getValue();
            } else {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity, (String)charset);
                }
                Header[] headers = response.getAllHeaders();
                EntityUtils.consume((HttpEntity)entity);
                map.put(HEADER, headers);
            }
            map.put(STATUSCODE, statusCode);
            map.put(DATA, result);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> get(String url, String sign, String charset) throws Exception {
        if (StringUtils.isEmpty((String)url)) {
            throw new RuntimeException("HttpClient,error url:" + url);
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(CONNECTTIMEOUT).setSocketTimeout(SOCKETTIMEOUT).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        if (StringUtils.isEmpty((String)charset)) {
            charset = CHARSET;
        }
        HttpGet httpget = new HttpGet(url);
        if (sign != null && !"".equals(sign.trim())) {
            httpget.setHeader("Signature", sign);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (CloseableHttpResponse response = null;){
            response = httpClient.execute((HttpUriRequest)httpget);
            String result = null;
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                if (statusCode != 302) {
                    httpget.abort();
                    throw new RuntimeException("HttpClient,error status code :" + statusCode);
                }
                result = response.getHeaders("location")[0].getValue();
            } else {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity, (String)charset);
                }
                Header[] headers = response.getAllHeaders();
                EntityUtils.consume((HttpEntity)entity);
                map.put(HEADER, headers);
            }
            map.put(STATUSCODE, statusCode);
            map.put(DATA, result);
        }
        return map;
    }

    public static String getPlain(Map<String, String> reqMap) {
        Object[] obj = reqMap.keySet().toArray();
        String value = "";
        StringBuilder reqstr = new StringBuilder("");
        Arrays.sort(obj);
        Object[] var8 = obj;
        int var7 = obj.length;
        for (int var6 = 0; var6 < var7; ++var6) {
            Object object = var8[var6];
            String s = object.toString();
            if (s.equalsIgnoreCase("Signature") || "Signature".equals(s) || !StringUtils.isNotEmpty((String)(value = StringUtils.trim((String)reqMap.get(s))))) continue;
            reqstr.append(s).append("=").append(value).append("&");
        }
        String plain = reqstr.substring(0, reqstr.length() - 1);
        return plain;
    }

    public static String getPlainEncode(Map<String, String> reqMap) {
        Object[] obj = reqMap.keySet().toArray();
        String value = "";
        StringBuilder reqstr = new StringBuilder("");
        Arrays.sort(obj);
        Object[] var8 = obj;
        int var7 = obj.length;
        for (int var6 = 0; var6 < var7; ++var6) {
            Object object = var8[var6];
            String s = object.toString();
            if (s.equalsIgnoreCase("Signature") || "Signature".equals(s) || !StringUtils.isNotEmpty((String)(value = reqMap.get(s)))) continue;
            try {
                value = URLEncoder.encode(value.replaceAll("\\+", "%2B"), CHARSET);
            }
            catch (Exception var11) {
                RuntimeException rex = new RuntimeException();
                rex.setStackTrace(var11.getStackTrace());
                throw rex;
            }
            reqstr.append(s).append("=").append(value).append("&");
        }
        String plain = reqstr.substring(0, reqstr.length() - 1);
        return plain;
    }

    public static InputStream downloadFile(ConfigContext apicontext, Map<String, String> reqMap, String fbPrivateKey) {
        String plain = UmHttpClient.getPlain(reqMap);
        String plainEncode = UmHttpClient.getPlainEncode(reqMap);
        String url = apicontext.getUrl() + "?" + plainEncode;
        String merId = apicontext.getMerId();
        String charset = apicontext.getCharset();
        if (charset == null || "".equals(charset)) {
            charset = CHARSET;
        }
        String sign = SignUtil.sign(plain, "RSA", fbPrivateKey);
        log.info(String.format("\u7b7e\u540d\uff1a%s", sign));
        if (StringUtils.isEmpty((String)url)) {
            throw new RuntimeException("HttpClient,error url:" + url);
        }
        try {
            URL finalUrl = new URL(url);
            HttpURLConnection httpURLConnection = (HttpURLConnection)finalUrl.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setConnectTimeout(20000);
            httpURLConnection.setReadTimeout(10000);
            httpURLConnection.setRequestProperty("Signature", sign);
            httpURLConnection.connect();
            return httpURLConnection.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

