/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.prepaycard;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.prepaycard.UmpayPrepayCardActivationResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 预付卡激活
 *
 * @author linzy
 * @version UmpayPrepayCardActivationRequest.java, v 0.1 2022-07-25 16:31:35
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UmpayPrepayCardActivationRequest extends UmBizRequest<UmpayPrepayCardActivationResponse> {

    private static final long serialVersionUID = -1315845068867770535L;

    /**
     * 预付卡卡号
     */
    @Length(max = 32, message = "预付卡卡号长度不能超过32")
    private String prepayCardNo;

    /**
     * 预付卡类型：1-线上卡；2-线下卡；
     */
    private Integer prepayCardType;

    /**
     * 预付卡面值，单位：元
     */
    private BigDecimal prepayCardAmount;

    /**
     * 预付卡售价，单位：元
     */
    private BigDecimal prepayCardPrice;
    /**
     * 预付卡有效期 20220725
     */
    @Length(max = 8, message = "预付卡有效期长度不能超过8")
    private String prepayCardExpiry;
    /**
     * 预付卡发放省份
     */
    private String provinceCode;
    /**
     * 预付卡发放城市
     */
    private String cityCode;
    /**
     * 服务商用户ID（消费者唯一id）
     */
    private String customerId;
    /**
     * 用户手机号
     */
    private String customerMobile;


    @Override
    public Class<UmpayPrepayCardActivationResponse> getResponseClass() {
        return UmpayPrepayCardActivationResponse.class;
    }
}