/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant.wx;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.merchant.wx.UmpayWxMerchantStateQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 微信授权状态查询
 *
 * @author
 * @version UmpayWxMerchantStateQueryRequest.java, v 0.1 2022-03-16 16:03:31
 */
@Data
public class UmpayWxMerchantStateQueryRequest extends UmBizRequest<UmpayWxMerchantStateQueryResponse> {

    private static final long serialVersionUID = -2213838555892111578L;


    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻成功后由平台返回如果一个store_id进行了多次微信签约，会返回所有微信子商户号的授权状态
     *
     * (特殊必填)
     */
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 微信子商户号，微信商户签约成功后返回，与store_id二选一必填
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "subMchId长度不能超过32")
    private String subMchId;

    @Override
    public Class<UmpayWxMerchantStateQueryResponse> getResponseClass() {
        return UmpayWxMerchantStateQueryResponse.class;
    }
}