/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.fund;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.fund.UmpayDrawResultQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 提现结果查询
 *
 * @author
 * @version UmpayDrawResultQueryRequest.java, v 0.1 2022-03-16 16:40:14
 */
@Data
public class UmpayDrawResultQueryRequest extends UmBizRequest<UmpayDrawResultQueryResponse> {

    private static final long serialVersionUID = -2213838555714151871L;


    /**
     * 服务商的提现单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outDrawNo长度不能超过64")
    private String outDrawNo;

    @Override
    public Class<UmpayDrawResultQueryResponse> getResponseClass() {
        return UmpayDrawResultQueryResponse.class;
    }
}