package com.fshows.umpay.sdk.request.coupon;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.coupon.UmpayWriteOffCouponQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 解冻结果查询
 *
 * @author liangyuanping
 * @version LiquidationWriteOffCouponRequest.java, v 0.1 2022-12-01 2:35 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UmpayWriteOffCouponQueryRequest extends UmBizRequest<UmpayWriteOffCouponQueryResponse> {

    /**
     * 服务商解冻单号,64个字符以内。可包含字母、数字、下划线;需保证在接入的服务商系统中不重复
     */
    private String outWriteoffNo;

    /**
     * 聚合收单平台解冻单号，在系统内唯一writeoff_no和out_writeoff_no二选一必填，优先取writeoff_no
     */
    private String writeoffNo;

    @Override
    public Class<UmpayWriteOffCouponQueryResponse> getResponseClass() {
        return UmpayWriteOffCouponQueryResponse.class;
    }
}