/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.activity;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.activity.UmpayWxActivityApplyResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 微信活动报名接口
 *
 * @author
 * @version UmpayWxActivityApplyRequest.java, v 0.1 2022-03-16 16:52:15
 */
@Data
public class UmpayWxActivityApplyRequest extends UmBizRequest<UmpayWxActivityApplyResponse> {

    private static final long serialVersionUID = -2213838555990032572L;


    /**
     * 聚合收单平台为商户分配的唯一&nbsp;ID,商户入驻后由平台返回；store_id和merchant_id二选一必填；
     *
     * (特殊必填)
     */
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在系统中唯一；store_id和merchant_id二选一必填；
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "merchantId长度不能超过32")
    private String merchantId;

    /**
     * 微信子商户号（一个商户含多个子商户号的情况下必填）
     *
     * (特殊必填)
     */
    @Length(max = 16, message = "subMchId长度不能超过16")
    private String subMchId;

    /**
     * 活动类型：schoolcanteen_001：教育食堂行业活动education_001：线下教培机构
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "activityType长度不能超过32")
    private String activityType;

    /**
     * 学校资质证明
     *
     * (特殊必填)
     */
    private String schoolQualificationProof;

    /**
     * 机构资质证明
     *
     * (特殊必填)
     */
    private String qualificationProof;

    /**
     * 合作资质证明
     *
     * (特殊必填)
     */
    private String cooperationQualificationProof;

    /**
     * 优惠费率承诺函
     *
     * (特殊必填)
     */
    private String activityRateCommitment;

    /**
     * 食堂内部用餐环境照片
     *
     * (特殊必填)
     */
    private String canteenEnvironmentPhoto;

    /**
     * 食堂门头照片
     *
     * (特殊必填)
     */
    private String canteenFrontPhoto;

    /**
     * 门头照
     *
     * (特殊必填)
     */
    private String storeDoorPhoto;

    /**
     * 办学许可证
     *
     * (特殊必填)
     */
    private String schoolLicenseProof;

    /**
     * 门店租赁相关证明
     *
     * (特殊必填)
     */
    private String storeTenancyProof;

    @Override
    public Class<UmpayWxActivityApplyResponse> getResponseClass() {
        return UmpayWxActivityApplyResponse.class;
    }
}