/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.activity;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.activity.UmpayAlipayActivityApplyResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 支付宝活动报名接口
 *
 * @author
 * @version UmpayAlipayActivityApplyRequest.java, v 0.1 2022-03-16 16:45:17
 */
@Data
public class UmpayAlipayActivityApplyRequest extends UmBizRequest<UmpayAlipayActivityApplyResponse> {

    private static final long serialVersionUID = -2213838555953964582L;


    /**
     * 聚合收单平台为商户分配的唯一&nbsp;ID,商户入驻后由平台返回；store_id和merchant_id二选一必填；
     *
     * (特殊必填)
     */
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在系统中唯一；store_id和merchant_id二选一必填；
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "merchantId长度不能超过32")
    private String merchantId;

    /**
     * 支付宝子商户号（一个商户含多个子商户号的情况下必填）
     *
     * (特殊必填)
     */
    @Length(max = 16, message = "alipayId长度不能超过16")
    private String alipayId;

    /**
     * 统一社会信用代码证（三证合一）、营业执照、事业单位法人证书、组织机构代码证
     *
     * (必填)
     */
    @NotBlank
    private String businessLicenseImg;

    /**
     * 商户行业资质照片
     *
     * (特殊必填)
     */
    private String industryQualificationImg;

    /**
     * 特殊费率对应的行业code，请联系我方运营人员
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 16, message = "industryCode长度不能超过16")
    private String industryCode;

    /**
     * 机构跟银行的合作协议关键页/机构银行合作授权函
     *
     * (特殊必填)
     */
    private String bankCooperationAgreement;

    /**
     * 银行开户证明/银行开户回单/委托代收党费党支部红头文件
     *
     * (特殊必填)
     */
    private String bankAccountProve;

    /**
     * 结算卡号
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "bankCardNo长度不能超过32")
    private String bankCardNo;

    /**
     * 结算卡持卡人姓名
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "bankCardName长度不能超过64")
    private String bankCardName;

    /**
     * 结算卡对应的支行名称
     *
     * (选填)
     */
    @Length(max = 64, message = "openBank长度不能超过64")
    private String openBank;

    /**
     * 收费样本
     *
     * (特殊必填)
     */
    private String chargeSample;

    /**
     * 负责人身份证正面照，可以上传法人身份证/代理人身份证/党支部书记身份证
     *
     * (必填)
     */
    @NotBlank
    private String legalPersonHeadsPic;

    /**
     * 负责人身份证反面照，可以上传法人身份证/代理人身份证/党支部书记身份证
     *
     * (必填)
     */
    @NotBlank
    private String legalPersonTailsPic;

    /**
     * 负责人授权函，如果上传代理人身份证，需补充法人授权函；上传党支部书记身份证，需补充党支部书记任命函或党组织授权函
     *
     * (选填)
     */
    private String legalPersonLicenseAuthPic;

    /**
     * 门头照
     *
     * (特殊必填)
     */
    private String storeFrontImg;

    /**
     * 店内环境照
     *
     * (特殊必填)
     */
    private String indoorPic;

    /**
     * 活动类型：特殊行业优惠费率：INDUSTRY_SPECIAL
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "activityType长度不能超过32")
    private String activityType;

    /**
     * 审核通过照片
     *
     * (选填)
     */
    private String passedImg;

    @Override
    public Class<UmpayAlipayActivityApplyResponse> getResponseClass() {
        return UmpayAlipayActivityApplyResponse.class;
    }
}