/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.merchant.wx;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 微信实名认证-撤销申请单
 *
 * @author
 * @version UmpayWxApplymentCancelResponse.java, v 0.1 2022-03-16 16:12:19
 */
@Data
public class UmpayWxApplymentCancelResponse implements Serializable {

    private static final long serialVersionUID = -2213838555652629579L;


    /**
     * 服务商申请单编号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "businessCode长度不能超过128")
    private String businessCode;

    /**
     * 申请单号
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "applymentId长度不能超过64")
    private String applymentId;

    /**
     * 状态描述
     *
     * (特殊必填)
     */
    @Length(max = 128, message = "remark长度不能超过128")
    private String remark;

    /**
     * 1、撤销成功、0、撤销失败
     *
     * (必填)
     */
    @NotNull
    private Integer state;

}