package com.fshows.umpay.sdk.enums;

import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.request.coupon.UmpayWriteOffCouponQueryRequest;
import com.fshows.umpay.sdk.request.coupon.UmpayWriteOffCouponRequest;
import com.fshows.umpay.sdk.request.coupon.UmpayWriteOffReturnQueryRequest;
import com.fshows.umpay.sdk.request.coupon.UmpayWriteOffReturnRequest;
import com.fshows.umpay.sdk.response.coupon.UmpayWriteOffCouponQueryResponse;
import com.fshows.umpay.sdk.response.coupon.UmpayWriteOffCouponResponse;
import com.fshows.umpay.sdk.response.coupon.UmpayWriteOffReturnQueryResponse;
import com.fshows.umpay.sdk.response.coupon.UmpayWriteOffReturnResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * @author liangyuanping
 * @version UmWriteOffCouponApiEnum.java, v 0.1 2022-12-01 2:30 PM
 */
public enum UmWriteOffCouponApiEnum implements UmpayApiDefinition {

    // 卡券核销
    WRITE_OFF_ORDER(
            "解冻",
            "liquidation.write.off.order",
            UmpayWriteOffCouponRequest.class,
            UmpayWriteOffCouponResponse.class
    ),
    WRITE_OFF_ORDER_QUERY(
            "解冻结果查询",
            "liquidation.write.off.order.query",
            UmpayWriteOffCouponQueryRequest.class,
            UmpayWriteOffCouponQueryResponse.class
    ),
    WRITE_OFF_RETURN_ORDER(
            "解冻退回",
            "liquidation.write.off.return.order",
            UmpayWriteOffReturnRequest.class,
            UmpayWriteOffReturnResponse.class
    ),
    WRITE_OFF_RETURN_QUERY(
            "解冻退回结果查询",
            "liquidation.write.off.return.query",
            UmpayWriteOffReturnQueryRequest.class,
            UmpayWriteOffReturnQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口方法签名
     */
    private String value;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;


    UmWriteOffCouponApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static UmWriteOffCouponApiEnum getByValue(String value) {
        UmWriteOffCouponApiEnum[] valueList = UmWriteOffCouponApiEnum.values();
        for (UmWriteOffCouponApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    /**
     * Getter method for property <tt>requestClass</tt>.
     *
     * @return property value of requestClass
     */
    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }


}