/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.umpay.sdk.enums;

import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.request.trade.order.UmpayFeeSubsidyUploadRequest;
import com.fshows.umpay.sdk.request.trade.order.UmpayOrderCloseRequest;
import com.fshows.umpay.sdk.request.trade.order.UmpayOrderQueryRequest;
import com.fshows.umpay.sdk.request.trade.order.UmpayOrderRefundRequest;
import com.fshows.umpay.sdk.request.trade.order.UmpayRefundQueryRequest;
import com.fshows.umpay.sdk.request.trade.order.UmpayUnionQueryUseridRequest;
import com.fshows.umpay.sdk.request.trade.pay.UmpayGetWxFaceAuthInfoRequest;
import com.fshows.umpay.sdk.request.trade.pay.UmpayPrePayRequest;
import com.fshows.umpay.sdk.request.trade.pay.UmpayScanCardRequest;
import com.fshows.umpay.sdk.response.trade.order.UmpayFeeSubsidyUploadResponse;
import com.fshows.umpay.sdk.response.trade.order.UmpayOrderCloseResponse;
import com.fshows.umpay.sdk.response.trade.order.UmpayOrderQueryResponse;
import com.fshows.umpay.sdk.response.trade.order.UmpayOrderRefundResponse;
import com.fshows.umpay.sdk.response.trade.order.UmpayRefundQueryResponse;
import com.fshows.umpay.sdk.response.trade.order.UmpayUnionQueryUseridResponse;
import com.fshows.umpay.sdk.response.trade.pay.UmpayGetWxFaceAuthInfoResponse;
import com.fshows.umpay.sdk.response.trade.pay.UmpayPrePayResponse;
import com.fshows.umpay.sdk.response.trade.pay.UmpayScanCardResponse;
import org.apache.commons.lang3.StringUtils;

public enum UmTradeApiEnum implements UmpayApiDefinition
{
    SCAN_CARD_PAY("\u6761\u7801\u652f\u4ed8\uff08\u88ab\u626b\uff1aB\u626bC\uff09", "aggregation.barcode.pay", UmpayScanCardRequest.class, UmpayScanCardResponse.class),
    PRE_PAY("\u7edf\u4e00\u652f\u4ed8\uff08\u4e3b\u626b\uff1aC\u626bB\uff09", "aggregation.prepay", UmpayPrePayRequest.class, UmpayPrePayResponse.class),
    ORDER_QUERY("\u8ba2\u5355\u67e5\u8be2", "aggregation.pay.query", UmpayOrderQueryRequest.class, UmpayOrderQueryResponse.class),
    ORDER_CLOSE("\u8ba2\u5355\u5173\u95ed", "liquidation.order.close", UmpayOrderCloseRequest.class, UmpayOrderCloseResponse.class),
    ORDER_REFUND("\u8ba2\u5355\u9000\u6b3e", "aggregation.pay.refund", UmpayOrderRefundRequest.class, UmpayOrderRefundResponse.class),
    REFUND_QUERY("\u8ba2\u5355\u9000\u6b3e\u67e5\u8be2", "aggregation.pay.refund.query", UmpayRefundQueryRequest.class, UmpayRefundQueryResponse.class),
    GET_WX_FACE_AUTH_INFO("\u83b7\u53d6\u5fae\u4fe1\u5237\u8138\u6388\u6743\u4fe1\u606f", "liquidation.wx.face.get_wxpayface_authinfo", UmpayGetWxFaceAuthInfoRequest.class, UmpayGetWxFaceAuthInfoResponse.class),
    UNION_QUERY_USERID("\u94f6\u8054\u4e91\u95ea\u4ed8\u83b7\u53d6\u7528\u6237\u6807\u8bc6", "aggregation.union.query.userid", UmpayUnionQueryUseridRequest.class, UmpayUnionQueryUseridResponse.class),
    ORDER_FEE_SUBSIDY_UPLOAD("\u624b\u7eed\u8d39\u8865\u8d34\u91d1\u4e0a\u4f20", "order.fee.subsidy.upload", UmpayFeeSubsidyUploadRequest.class, UmpayFeeSubsidyUploadResponse.class);

    private String name;
    private String value;
    private Class requestClass;
    private Class responseClass;

    private UmTradeApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static UmTradeApiEnum getByValue(String value) {
        UmTradeApiEnum[] valueList;
        for (UmTradeApiEnum v : valueList = UmTradeApiEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getValue(), (CharSequence)value)) continue;
            return v;
        }
        return null;
    }

    @Override
    public String getMethod() {
        return this.value;
    }

    @Override
    public Class getRequestClass() {
        return this.requestClass;
    }

    @Override
    public Class getResponseClass() {
        return this.responseClass;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }
}

