/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.umpay.bankchannel.util;

import cn.hutool.core.io.IoUtil;
import com.fshows.umpay.bankchannel.util.RSAUtil;
import com.fshows.umpay.sdk.util.SignUtil;
import com.umpay.http.UMFFileClient;
import com.umpay.http.UMFHttpClient;
import com.umpay.mer.ConfigContext;
import com.umpay.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmFileClinet {
    private static final Logger log = LoggerFactory.getLogger(UMFFileClient.class);
    public static final String CHARSET = "UTF-8";
    public static final String FILE = "file";
    public static final String DATA = "data";
    public static final String RULE = "spay";
    public static final int STATUS_200 = 200;
    public static final int STATUS_302 = 302;
    public static int CONNECTTIMEOUT = 6000;
    public static int SOCKETTIMEOUT = 120000;

    public static Map<String, Object> post(ConfigContext apicontext, String body, File file, String fbPrivateKey) throws Exception {
        String url = apicontext.getUrl();
        String merId = apicontext.getMerId();
        String rsaCharset = apicontext.getCharset();
        if (rsaCharset == null || "".equals(rsaCharset)) {
            rsaCharset = CHARSET;
        }
        String sign = SignUtil.sign(body, "RSA", fbPrivateKey);
        return UmFileClinet.post(url, body, file, sign, rsaCharset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> post(String url, String json, File file, String sign, String charset) throws Exception {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(CONNECTTIMEOUT).setSocketTimeout(SOCKETTIMEOUT).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        if (StringUtils.isEmpty((String)charset)) {
            charset = CHARSET;
        }
        HttpPost httpPost = new HttpPost(url);
        if (sign != null && !"".equals(sign.trim())) {
            httpPost.setHeader("Signature", sign);
        }
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addPart(FILE, (ContentBody)new FileBody(file));
        multipartEntityBuilder.addPart(DATA, (ContentBody)new StringBody(json, ContentType.TEXT_PLAIN));
        HttpEntity entity = multipartEntityBuilder.build();
        httpPost.setEntity(entity);
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (CloseableHttpResponse response = null;){
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            String result = null;
            if (statusCode != 200) {
                if (statusCode != 302) {
                    httpPost.abort();
                    throw new RuntimeException("HttpClient,error status code :" + statusCode);
                }
                result = response.getHeaders("location")[0].getValue();
            } else {
                entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity, (String)charset);
                }
                Header[] headers = response.getAllHeaders();
                EntityUtils.consume((HttpEntity)entity);
                map.put("header", headers);
            }
            map.put("statusCode", statusCode);
            map.put(DATA, result);
        }
        return map;
    }

    public static void download(ConfigContext apicontext, Map<String, String> reqMap, String filtPath) throws Exception {
        String plain = UMFHttpClient.getPlain(reqMap);
        String plainEncode = UMFHttpClient.getPlainEncode(reqMap);
        String url = apicontext.getUrl();
        String merId = apicontext.getMerId();
        String charset = apicontext.getCharset();
        if (charset == null || "".equals(charset)) {
            charset = CHARSET;
        }
        String sign = RSAUtil.createSign(plain, merId, RULE, charset);
        log.info(String.format("\u7b7e\u540d\uff1a%s", sign));
        UmFileClinet.download(url + "?" + plainEncode, sign, charset, filtPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String url, String sign, String charset, String filePath) throws Exception {
        block14: {
            if (StringUtils.isEmpty((String)url)) {
                throw new RuntimeException("HttpClient,error url:" + url);
            }
            RequestConfig config = RequestConfig.custom().setConnectTimeout(CONNECTTIMEOUT).setSocketTimeout(SOCKETTIMEOUT).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            if (StringUtils.isEmpty((String)charset)) {
                charset = CHARSET;
            }
            HttpGet httpget = new HttpGet(url);
            if (sign != null && !"".equals(sign.trim())) {
                httpget.setHeader("Signature", sign);
            }
            try (CloseableHttpResponse response = null;){
                response = httpClient.execute((HttpUriRequest)httpget);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    httpget.abort();
                    throw new RuntimeException("HttpClient,error status code :" + statusCode);
                }
                HttpEntity entity = response.getEntity();
                if (entity == null) break block14;
                File desc = new File(filePath);
                File folder = desc.getParentFile();
                folder.mkdirs();
                InputStream is = null;
                FileOutputStream os = null;
                try {
                    is = entity.getContent();
                    os = new FileOutputStream(desc);
                    IoUtil.copy((InputStream)is, (OutputStream)os);
                }
                catch (Exception var25) {
                    try {
                        UmFileClinet.close(is, os);
                        var25.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        UmFileClinet.close(is, os);
                        throw throwable;
                    }
                    UmFileClinet.close(is, os);
                    break block14;
                }
                UmFileClinet.close(is, os);
            }
        }
    }

    private static void close(InputStream is, OutputStream os) throws Exception {
        if (is != null) {
            is.close();
        }
        if (os != null) {
            os.close();
        }
    }
}

