/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.response.terminal.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * POS绑定状态查询
 *
 * @author liluqing
 * @version UmpayTermInfoResponse.java, v 0.1 2022-03-16 16:27
 */
@Data
public class UmpayTermInfoResponse implements Serializable {

    private static final long serialVersionUID = -2213838555773263013L;

    /**
     * 终端机具状态0-库存状态（绑定中）；1-正常状态（绑定成功）；2-挂起状态；3-临时挂起状态；4-报废状态；5-等待二次分拨；6-解绑定；7-绑定中；8-解绑中；
     *
     * (特殊必填)
     */
    private Integer terminalStatus;

    /**
     * 厂商编号
     *
     * (特殊必填)
     */
    @Length(max = 3, message = "provId长度不能超过3")
    private String provId;

    /**
     * 终端型号
     *
     * (特殊必填)
     */
    @Length(max = 4, message = "modelId长度不能超过4")
    private String modelId;

    /**
     * 终端SN号
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "snNumber长度不能超过64")
    private String snNumber;

    /**
     * 商户ID
     *
     * (特殊必填)
     */
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 机具出库日期
     *
     * (特殊必填)
     */
    @Length(max = 8, message = "outDate长度不能超过8")
    private String outDate;

    /**
     * 机具厂商名称
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "provName长度不能超过64")
    private String provName;

    /**
     * 机具终端型号名称
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "modelName长度不能超过32")
    private String modelName;

    /**
     * 平台类型：1-支付宝；2-微信；8-银行卡刷卡；
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "payPlatformType长度不能超过1")
    private String payPlatformType;

    /**
     * 终端设备号；
     *
     * (特殊必填)
     */
    @Length(max = 8, message = "terminalId长度不能超过8")
    private String terminalId;

    /**
     * 子商户号；
     *
     * (选填)
     */
    @Length(max = 32, message = "subMchId长度不能超过32")
    private String subMchId;

    /**
     * 设备类型取值范围：02 传统POS03 mPOS04 智能POS08 手机POS10 条码支付受理终端11 辅助终端
     *
     * (选填)
     */
    private Integer terminalType;

    /**
     * 受理终端布放地址的纬度如服务商未上送纬度，则由业务系统根据装机地址生成经纬度信息
     *
     * (选填)
     */
    @Length(max = 32, message = "terminalGpsLat长度不能超过32")
    private String terminalGpsLat;

    /**
     * 受理终端布放地址的经度如服务商未上送经度，则由业务系统根据装机地址生成经纬度信息
     *
     * (选填)
     */
    @Length(max = 32, message = "terminalGpsLong长度不能超过32")
    private String terminalGpsLong;
}