/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.merchant;

import com.fshows.umpay.sdk.response.merchant.item.MerchantTerminalDetailResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 支付平台签约
 * 针对在<商户入驻>时只入驻了某一支付平台的商户，例如只入驻了微信，可调用本接口帮助商户开通支付宝的支付业务；
 *
 * @author
 * @version UmpayMerchantSignResponse.java, v 0.1 2022-03-16 17:02:33
 */
@Data
public class UmpayMerchantSignResponse implements Serializable {

    private static final long serialVersionUID = -2213838555878724066L;


    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻后由平台返回
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 支付宝子商户号；支付宝签约成功时返回；
     * <p>
     * (特殊必填)
     */
    @Length(max = 16, message = "alipayId长度不能超过16")
    private String alipayId;

    /**
     * 支付宝签约失败原因
     * <p>
     * (特殊必填)
     */
    @Length(max = 128, message = "aliMsg长度不能超过128")
    private String aliMsg;

    /**
     * 微信子商户号，微信签约成功时返回；
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "subMchId长度不能超过32")
    private String subMchId;

    /**
     * 微信签约失败原因
     * <p>
     * (特殊必填)
     */
    @Length(max = 128, message = "wxMsg长度不能超过128")
    private String wxMsg;

    /**
     * 云闪付子商户号，云闪付签约成功时返回；
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "unionId长度不能超过32")
    private String unionId;

    /**
     * 云闪付签约失败原因
     * <p>
     * (特殊必填)
     */
    @Length(max = 128, message = "unionMsg长度不能超过128")
    private String unionMsg;

    /**
     * 中行数币子商户号
     * 入驻成功且开通数币交易功能成功后返回，须子商户号及子钱包开通后才能交易
     */
    private String bocEcnyId;

    /**
     * 中行数币开通状态
     * 0-审核中 1-商户开立成功 2-商户开立失败
     */
    private String bocEcnyState;

    /**
     * 中行数币开通失败原因
     */
    private String bocEcnyMsg;

    /**
     * 终端信息
     * <p>
     * (选填)
     */
    private List<MerchantTerminalDetailResponse> terminalList;


}