/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant.wx;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.merchant.wx.UmpayWxApplymentQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 微信实名认证-查询申请单审核状态
 *
 * @author
 * @version UmpayWxApplymentQueryRequest.java, v 0.1 2022-03-16 16:14:17
 */
@Data
public class UmpayWxApplymentQueryRequest extends UmBizRequest<UmpayWxApplymentQueryResponse> {

    private static final long serialVersionUID = -2213838555698225023L;


    /**
     * 申请单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "applymentId长度不能超过64")
    private String applymentId;

    /**
     * 服务商申请单编号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "businessCode长度不能超过128")
    private String businessCode;

    @Override
    public Class<UmpayWxApplymentQueryResponse> getResponseClass() {
        return UmpayWxApplymentQueryResponse.class;
    }
}