/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant.wx;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.merchant.wx.UmpayWxApplymentCreateResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 微信实名认证-提交申请单
 *
 * @author
 * @version UmpayWxApplymentCreateRequest.java, v 0.1 2022-03-16 16:08:45
 */
@Data
public class UmpayWxApplymentCreateRequest extends UmBizRequest<UmpayWxApplymentCreateResponse> {

    private static final long serialVersionUID = -2213838555696772699L;


    /**
     * 服务商申请单编号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "businessCode长度不能超过128")
    private String businessCode;

    /**
     * 聚合收单平台为商户分配的唯一&nbsp;ID,商户入驻后由平台返回；store_id和merchant_id二选一必填；
     *
     * (特殊必填)
     */
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在系统中唯一；store_id和merchant_id二选一必填；
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "merchantId长度不能超过32")
    private String merchantId;

    /**
     * 微信子商户号，一个商户
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "subMchId长度不能超过32")
    private String subMchId;

    /**
     * 回调地址:申请单申请受理状态通知
     *
     * (特殊必填)
     */
    @Length(max = 128, message = "notifyUrl长度不能超过128")
    private String notifyUrl;

    @Override
    public Class<UmpayWxApplymentCreateResponse> getResponseClass() {
        return UmpayWxApplymentCreateResponse.class;
    }
}