/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.machine;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.machine.UmpayMachineBindOrUnBindResponse;
import lombok.Data;

/**
 * @author
 * @version UmpayMachineBindOrUnBindRequest.java, v 0.1 2022-04-12 14:09:59
 */
@Data
public class UmpayMachineBindOrUnBindRequest extends UmBizRequest<UmpayMachineBindOrUnBindResponse> {

    /**
     * 商户ID
     */
    @JSONField(name = "store_id")
    private String storeId;

    /**
     * 操作类型
     * 0-pos终端绑定；1-pos终端解绑
     */
    @JSONField(name = "bind_type")
    private Integer bindType;

    /**
     *终端厂商编号，联系聚合平台运营人员；
     * 若terminal_type<>11-辅助终端，则prov_id必填；
     */
    @JSONField(name = "prov_id")
    private String provId;

    /**
     *终端型号，联系聚合平台运营人员；
     * 若terminal_type<>11-辅助终端，则model_id必填；
     */
    @JSONField(name = "model_id")
    private String modelId;

    /**
     *终端SN号；可以为TUSN，
     * 若terminal_type<>11-辅助终端，则sn_number必填；
     */
    @JSONField(name = "sn_number")
    private String snNumber;

    /**
     *子商户号，当一个商户存在多个子商户号时必填；
     */
    @JSONField(name = "sub_mch_id")
    private String subMchId;

    /**
     *装机地的省编码，如果省编码、市编码、区编码、详细地址中任意上送了一个字段，则4个字段都必填
     */
    @JSONField(name = "install_province_code")
    private String installProvinceCode;

    /**
     *装机地的市编码，如果省编码、市编码、区编码、详细地址中任意上送了一个字段，则4个字段都必填
     */
    @JSONField(name = "install_city_code")
    private String installCityCode;

    /**
     *装机地的区编码，如果省编码、市编码、区编码、详细地址中任意上送了一个字段，则4个字段都必填
     */
    @JSONField(name = "install_area_code")
    private String installAreaCode;

    /**
     *装机详细地址，如果省编码、市编码、区编码、详细地址中任意上送了一个字段，则4个字段都必填
     */
    @JSONField(name = "install_address")
    private String installAddress;

    /**
     *支付平台：1-支付宝；2-微信；8-银行卡刷卡；默认8-银行卡刷卡；
     */
    @JSONField(name = "pay_platform_type")
    private String payPlatformType;

    /**
     *设备类型
     * 取值范围：
     * 取值 取值说明
     * 02 传统POS
     * 03 mPOS
     * 04 智能POS
     * 08 手机POS
     * 10 条码支付受理终端
     * 11  辅助终端
     * 默认：10 条码支付受理终端；
     */
    @JSONField(name = "terminal_type")
    private String terminalType;

    /**
     *终端设备号；
     * 当bind_type=1-pos终端解绑时，
     * terminal_id和（prov_id、model_id、sn_number）二选一必填；
     */
    @JSONField(name = "terminal_id")
    private String terminalId;

    /**
     *受理终端布放地址的纬度
     * 如服务商未上送纬度，则由业务系统根据装机地址生成经纬度信息
     */
    @JSONField(name = "terminal_gps_lat")
    private String terminalGpsLat;

    /**
     * 受理终端布放地址的经度
     * 如服务商未上送经度，则由业务系统根据装机地址生成经纬度信息
     */
    @JSONField(name = "terminal_gps_long")
    private String terminalGpsLong;

    @Override
    public Class<UmpayMachineBindOrUnBindResponse> getResponseClass() {
        return UmpayMachineBindOrUnBindResponse.class;
    }
}