package com.fshows.umpay.sdk.request.coupon;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.request.trade.pay.item.UmpayPromotionDetailRequest;
import com.fshows.umpay.sdk.response.coupon.UmpayWriteOffCouponResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author liangyuanping
 * @version LiquidationWriteOffCouponRequest.java, v 0.1 2022-12-01 2:35 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UmpayWriteOffCouponRequest extends UmBizRequest<UmpayWriteOffCouponResponse> {
    /**
     * 聚合收单平台为商户分配的惟一 ID,商户入驻后由平台返回
     */
    private String storeId;
    /**
     * 服务商解冻单号,64个字符以内。可包含字母、数字、下划线;需保证在接入的服务商系统中不重复
     */
    private String outWriteoffNo;
    /**
     * 解冻金额，单位：元，精确到小数点后两位，取值范围[0.01,100000000]
     */
    private BigDecimal amount;
    /**
     * 解冻补贴金，单位：元，精确到小数点后两位
     * 若不传，则按比例解冻；
     * 若全额解冻，则与延迟结算单补贴金额一致；
     */
    private BigDecimal subsidyFee;
    /**
     * 聚合清算延迟结算单号
     * order_sn和out_order_sn二选一必填，优先取order_sn；
     */
    private String orderSn;
    /**
     * 服务商延迟结算单号
     * order_sn和out_order_sn二选一必填，优先取order_sn；
     */
    private String outOrderSn;
    /**
     * 核销城市
     */
    private String writeoffCity;
    /**
     * 核销广场名称
     */
    private String writeoffSquare;
    /**
     * 核销用户id
     * 非购券单核销时必传
     * add by liangyuanping 2023-01-30
     */
    private String writeoffUserId;
    /**
     * 营销补贴账户
     * 非购券单核销时必传
     * add by liangyuanping 2023-01-30
     */
    private String subsidyAccount;
    /**
     * 解冻类型：1-赠券核销；
     */
    private Integer writeoffType;
    /**
     * 券信息
     */
    private List<UmpayPromotionDetailRequest> promotionDetail;


    @Override
    public Class<UmpayWriteOffCouponResponse> getResponseClass() {
        return UmpayWriteOffCouponResponse.class;
    }
}