/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.umpay.bankchannel.util;

import com.umpay.factory.RSACertFactory;
import com.umpay.util.Base64;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

/**
 * @author liluqing
 * @version RSAUtil.java, v 0.1 2023-04-06 14:26
 */
public class RSAUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";

    public RSAUtil() {
    }

    public static byte[] sign(PrivateKey pk, byte[] data, String signProject) {
        byte[] sb = (byte[]) null;

        try {
            String sha = null;
            if ("rest".equals(signProject)) {
                sha = "SHA256withRSA";
            } else if ("spay".equals(signProject)) {
                sha = "SHA1withRSA";
            }

            Signature signature = Signature.getInstance(sha);
            signature.initSign(pk);
            signature.update(data);
            sb = signature.sign();
            return sb;
        } catch (Exception var6) {
            return null;
        }
    }

    public static X509Certificate genCertificate(byte[] certData) {
        ByteArrayInputStream bais = new ByteArrayInputStream(certData);

        try {
            CertificateFactory e = CertificateFactory.getInstance("X.509");
            return (X509Certificate) e.generateCertificate(bais);
        } catch (Exception var3) {
            return null;
        }
    }

    public static boolean verifySign(X509Certificate cert, byte[] plain, byte[] signData) {
        try {
            Signature e = Signature.getInstance("SHA256withRSA");
            e.initVerify(cert);
            e.update(plain);
            return e.verify(signData);
        } catch (Exception var4) {
            return false;
        }
    }

    public static String createSign(String plain, String merId, String signRule, String charset) {
        String sign = null;
        InputStream in = null;
        if (charset == null || "".equals(charset)) {
            charset = "UTF-8";
        }

        try {
            PrivateKey pk = RSACertFactory.getPk(merId);
            byte[] signData = sign(pk, plain.getBytes(charset), signRule);
            sign = new String(Base64.encode(signData));
        } catch (Exception var16) {
            var16.printStackTrace();
        } finally {
            try {
                if (in != null) {
                    ((InputStream) in).close();
                }
            } catch (IOException var15) {
                var15.printStackTrace();
            }

        }

        return sign;
    }

    public static boolean verifySign(String plain, String sign, String charset) throws Exception {
        if (charset == null || "".equals(charset)) {
            charset = "UTF-8";
        }

        X509Certificate cert = RSACertFactory.getUmfCert();
        byte[] signData = Base64.decode(sign.getBytes(charset));
        return verify(cert, plain.getBytes(charset), signData);
    }

    private static boolean verify(X509Certificate cert, byte[] plain, byte[] signData) {
        try {
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initVerify(cert);
            sig.update(plain);
            return sig.verify(signData);
        } catch (Exception var4) {
            return false;
        }
    }
}