/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.umpay.bankchannel.response.merchant;

import lombok.Data;

/**
 * 进件结果查询
 *
 * @author liluqing
 * @version UmBankEntryQueryResponse.java, v 0.1 2023-04-07 10:50
 */
@Data
public class UmBankEntryQueryResponse {

    /**
     * 商户订单号
     */
    private String orderId;
    /**
     * 商户订单时间
     */
    private String orderDate;

    /**
     * 进件状态：
     * <p>
     * 1：鉴权成功
     * 2：鉴权失败
     * 3：电子签约中
     * 4：电子签约失败
     * 5：电子签约成功
     * 6：资料校验中
     * 7：待账户验证 (四要素鉴权)
     * 8：审核中
     * 9：处理中
     * 10：已通过
     * 11：进件失败
     * 12: 未知（可以认为进件失败）
     */
    private String orderState;

    /**
     * 电子账簿 ID
     */
    private String acctId;

    /**
     * 电子账簿账簿号
     */
    private String acctNo;

    /**
     * 给用户分配的唯一编号
     */
    private String merCustId;

    /**
     * 审核通过时间 格式：yyyy-MM-dd HH:mm:ss
     */
    private String auditedTime;

    /**
     * 失败原因
     */
    private String auditMsg;
}