package com.fshows.umpay.bankchannel.response.funds;

import lombok.Data;

/**
 * @author liangyuanping
 * @version BankWithdrawQueryResponse.java, v 0.1 2023-04-06 7:11 PM
 */
@Data
public class UmBankWithdrawQueryResponse {
    /**
     * 商户唯一流水号
     */
    private String merTrace;
    /**
     * 商户订单号
     */
    private String orderId;
    /**
     * 订单时间 格式：yyyyMMdd
     */
    private String orderDate;
    /**
     * 联动订单号
     */
    private String tradeNo;
    /**
     * 对账日期，格式：YYYYMMDD
     * 提现成功时返回
     */
    private String merCheckDate;
    /**
     * 电子账户号
     */
    private String accId;
    /**
     * 1-提现成功，2-提现失败，3-处理中，4-结果未明
     */
    private String status;
    /**
     * 提现金额，币种人民币，单位为分
     */
    private String amount;
    /**
     * 失败原因 失败时有值
     */
    private String reason;
}