/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.bankchannel.response;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 公共响应参数
 *
 * @author youmingming
 * @version UmBizRequest.java, v 0.1 2022-02-09 下午5:12 youmingming
 */
@Data
public class UmBankBaseResponse<T> implements Serializable {

    private static final long serialVersionUID = 1353569682550857298L;

    /**
     * 响应码
     */
    public String retCode;

    /**
     * 响应描述
     */
    public String retMsg;

    /**
     * 业务数据
     */
    public T data;

    /**
     * 相关接口links
     */
    public List<UmBankLinkResponse> links;
}