/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.umpay.bankchannel.request.merchant.item;

import com.fshows.umpay.annotation.EncryptField;
import com.fshows.umpay.bankchannel.request.UmBankBizItemRequest;
import lombok.Data;

/**
 * 组织机构代码证
 *
 * @author liluqing
 * @version UmBankEnterpriseLicenseRequest.java, v 0.1 2023-04-07 10:39
 */
@Data
public class UmBankLegalPersonRequest extends UmBankBizItemRequest {

    /**
     * 法人姓名
     */
    @EncryptField
    private String legalName;
    /**
     * 法人证件号
     */
    @EncryptField
    private String legalIdcard;
    /**
     * 法人证件类型
     */
    private String legalIdcardType;
    /**
     * 证件正面图片media_id
     */
    private String idCardFrontMediaId;
    /**
     * 证件反面图片media_id
     */
    private String idCardBackMediaId;
    /**
     * 证件有效期
     */
    private String legalIdcardValidDate;
    /**
     * 法人手机号
     */
    @EncryptField
    private String legalMobile;
}