/*
 * fshows.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.umpay.bankchannel.request.merchant;

import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.merchant.UmBankDownloadElectronicReceiptResponse;
import com.fshows.umpay.bankchannel.response.merchant.UmBankDownloadStatementResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author FanJingchen
 * @version UmBankDownloadStatementRequest.java, v 0.1 2023-05-15 15:22 FanJingchen
 */
@Data
public class UmBankDownloadStatementRequest extends UmBankBizRequest<UmBankDownloadStatementResponse> implements Serializable {
    /**
     * mer id
     */
    private String merId;
    /**
     * 版本
     */
    private String version;
    /**
     * 对账日期，小于当天，格式：yyyyMMdd
     */
    private String merCheckDate;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<UmBankDownloadStatementResponse> getResponseClass() {
        return UmBankDownloadStatementResponse.class;
    }
}
