/*
 * fshows.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.umpay.bankchannel.request.merchant;

import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.merchant.UmBankDownloadElectronicReceiptResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author FanJingchen
 * @version UmBankDownloadElectronicReceiptRequest.java, v 0.1 2023-05-15 09:59 FanJingchen
 */
@Data
public class UmBankDownloadElectronicReceiptRequest extends UmBankBizRequest<UmBankDownloadElectronicReceiptResponse> implements Serializable {

    /**
     * 商户号
     */
    private String merId;
    /**
     * 版本号，定值：1.0
     */
    private String version;
    /**
     * 订单编号
     */
    private String orderId;
    /**
     * 订单时间 格式：yyyyMMdd
     */
    private String orderDate;
    /**
     * 查询类型
     * 1转账
     * 2批量转账子订单
     * 3入金
     * 4提现
     */
    private String queryType;
    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<UmBankDownloadElectronicReceiptResponse> getResponseClass() {
        return UmBankDownloadElectronicReceiptResponse.class;
    }
}
