/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.umpay.bankchannel.request.merchant;

import com.fshows.umpay.annotation.EncryptField;
import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.merchant.UmBankBindCardResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * 企业换绑卡请求
 *
 * @author liluqing
 * @version UmBankBindCardRequest.java, v 0.1 2023-05-06 11:24
 */
@Data
public class UmBankBindCardRequest extends UmBankBizRequest<UmBankBindCardResponse> implements Serializable {

    /**
     * 订单编号，支持数字、英文字母组合使用
     */
    private String orderId;

    /**
     * 变长8	订单时间 格式：yyyyMMdd
     */
    private String orderDate;

    /**
     * 给用户分配的唯一编号
     */
    private String merCustId;

    /**
     * 银行卡账户类型：
     * 一，若主体为企业，可填写：
     * 2-对公账户
     * 二 、若主体为个体工商户， 可填写：
     * 1-对私账户，2-对公账户
     */
    private String bankcardType;

    /**
     * 银行编码，若账户类型为
     * 1 - 对私账户时，非必传
     * 2 - 对公账户时，必传
     * 银行编码查看附件
     */
    private String bankCode;

    /**
     * 联行号 若账户类型为
     * 1-对私账户时，非必传
     * 2-对公账户时，必传
     * 银行联行号查看附件
     */
    private String cnapsCode;

    /**
     * 银行卡卡号 UTF-8编码后使用联动公钥进行RSA加密，最后使用BASE64编码
     */
    @EncryptField
    private String bankAccount;


    @Override
    public Class<UmBankBindCardResponse> getResponseClass() {
        return UmBankBindCardResponse.class;
    }
}