/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.umpay.bankchannel.request.merchant;

import com.fshows.umpay.annotation.EncryptField;
import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.merchant.UmBankBindCardRemoveResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * 企业删除绑定账户
 *
 * @author liluqing
 * @version UmBankBindCardRequest.java, v 0.1 2023-05-06 11:24
 */
@Data
public class UmBankBindCardRemoveRequest extends UmBankBizRequest<UmBankBindCardRemoveResponse> implements Serializable {

    /**
     * 订单编号，支持数字、英文字母组合使用
     */
    private String orderId;

    /**
     * 变长8	订单时间 格式：yyyyMMdd
     */
    private String orderDate;

    /**
     * 给用户分配的唯一编号
     */
    private String merCustId;

    /**
     * 银行卡卡号 UTF-8编码后使用联动公钥进行RSA加密，最后使用BASE64编码
     */
    @EncryptField
    private String bankAccount;


    @Override
    public Class<UmBankBindCardRemoveResponse> getResponseClass() {
        return UmBankBindCardRemoveResponse.class;
    }
}