/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.umpay.bankchannel.request.merchant;

import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.merchant.UmBankBindCardQueryResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * 绑卡结果查询
 *
 * @author liluqing
 * @version UmBankBindCardQueryRequest.java, v 0.1 2023-05-06 11:34
 */
@Data
public class UmBankBindCardQueryRequest extends UmBankBizRequest<UmBankBindCardQueryResponse> implements Serializable {

    /**
     * 订单编号，支持数字、英文字母组合使用
     */
    private String orderId;

    /**
     * 订单时间 格式：yyyyMMdd
     */
    private String orderDate;

    @Override
    public Class<UmBankBindCardQueryResponse> getResponseClass() {
        return UmBankBindCardQueryResponse.class;
    }
}