package com.fshows.umpay.bankchannel.request.funds;

import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.funds.UmBankWithdrawQueryResponse;
import com.google.gson.annotations.SerializedName;
import lombok.Data;

/**
 * @author liangyuanping
 * @version BankWithdrawQueryRequest.java, v 0.1 2023-04-06 6:24 PM
 */
@Data
public class UmBankWithdrawQueryRequest extends UmBankBizRequest<UmBankWithdrawQueryResponse> {

    /**
     * 提现时的商户订单号
     */
    @SerializedName("order_id")
    private String orderId;
    /**
     * 订单时间 格式：yyyyMMdd
     */
    @SerializedName("order_date")
    private String orderDate;

    @Override
    public Class<UmBankWithdrawQueryResponse> getResponseClass() {
        return UmBankWithdrawQueryResponse.class;
    }
}