package com.fshows.umpay.bankchannel.model.withdraw;

import com.fshows.umpay.bankchannel.model.res.WxhWithdrawalRes;
import com.fshows.umpay.sdk.request.MerchantBaseRequest;
import com.umpay.dto.UMFResponse;
import com.umpay.util.UMFUtil;

public class WxhWithdraw extends MerchantBaseRequest {

	private String order_id;//	商户订单号	变长20	商户订单号支持数字、英文字母，其他字符不建议使用  长度4至20位  非空

	private String order_date;//	商户订单日期	定长8	商户生成订单的日期，格式YYYYMMDD  非空

	private String mer_cust_id; // 用户唯一编号 非空

	private String acct_id;// 电子账户号 非空

	private String mer_trace;// 商户交易流水号 非空

	private String card_id;// 银行卡号 需加密 非空

	private String amount;//	提现金额	最少200000（2000元） 变长13 单位为分 非空

	protected String remark;//备注信息	变长30

	private String notify_url; // 结果异步通知地址

	private String url = "/wxh/withdrawal/balanceWithdrawal";


	@Override
	public String getRequestUrl() {
		return baseUrl + url;
	}

	@Override
	public WxhWithdrawalRes doRequest() throws Exception {
		UMFResponse.Message<WxhWithdrawalRes> response = UMFUtil.post(createAPIContext(), this, WxhWithdrawalRes.class);
		MerchantBaseRequest baseResult = convertResult(response, WxhWithdrawalRes.class);
		if (baseResult == null)
			return null;
		return (WxhWithdrawalRes) baseResult;
	}

	public String getOrder_id() {
		return order_id;
	}

	public void setOrder_id(String order_id) {
		this.order_id = order_id;
	}

	public String getOrder_date() {
		return order_date;
	}

	public void setOrder_date(String order_date) {
		this.order_date = order_date;
	}

	public String getMer_cust_id() {
		return mer_cust_id;
	}

	public void setMer_cust_id(String mer_cust_id) {
		this.mer_cust_id = mer_cust_id;
	}

	public String getAcct_id() {
		return acct_id;
	}

	public void setAcct_id(String acct_id) {
		this.acct_id = acct_id;
	}

	public String getMer_trace() {
		return mer_trace;
	}

	public void setMer_trace(String mer_trace) {
		this.mer_trace = mer_trace;
	}

	public String getCard_id() {
		return card_id;
	}

	public void setCard_id(String card_id) {
		this.card_id = card_id;
	}

	public String getAmount() {
		return amount;
	}

	public void setAmount(String amount) {
		this.amount = amount;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getNotify_url() {
		return notify_url;
	}

	public void setNotify_url(String notify_url) {
		this.notify_url = notify_url;
	}

	@Override
	public String toString() {
		return "WxhWithdraw{" +
				"order_id='" + order_id + '\'' +
				", order_date='" + order_date + '\'' +
				", mer_cust_id='" + mer_cust_id + '\'' +
				", acct_id='" + acct_id + '\'' +
				", mer_trace='" + mer_trace + '\'' +
				", card_id='" + card_id + '\'' +
				", amount='" + amount + '\'' +
				", remark='" + remark + '\'' +
				", notify_url='" + notify_url + '\'' +
				", version='" + version + '\'' +
				", mer_id='" + mer_id + '\'' +
				", ret_code='" + ret_code + '\'' +
				", ret_msg='" + ret_msg + '\'' +
				", links=" + links +
				'}';
	}
}
