package com.fshows.umpay.bankchannel.model.transfer;

import com.fshows.umpay.sdk.request.MerchantBaseRequest;
import com.umpay.dto.UMFResponse;
import com.umpay.util.UMFUtil;
import lombok.Data;
import lombok.ToString;

/**
 * @author HEYUNHANG
 * @date 2023/3/28 15:59
 */
@ToString(callSuper = true)
@Data
public class TransferConfirm extends MerchantBaseRequest {

    private String order_id;

    private String order_date;//YYYYMMDD

    private String mer_trace;

    private String verify_code;


    //响应参数

    /*private String order_id;

    private String order_date;

    private String mer_trace;*/

    /**
     * 交易状态.
     * 0-创建，1-成功，2-失败，3-处理中
     */
    private String status;

    /**
     * 对账日期
     * YYYYMMDD
     */
    private String mer_check_date;

    /**
     * 联动系统唯一订单号
     */
    private String trade_no;

    private String url = "/wxh/transfer/transferConfirm";


    @Override
    public String getRequestUrl() {
        return baseUrl + url;
    }

    @Override
    public TransferConfirm doRequest() throws Exception {
        UMFResponse.Message<TransferConfirm> response = UMFUtil.post(createAPIContext(), this, TransferConfirm.class);
        MerchantBaseRequest baseResult = convertResult(response, TransferConfirm.class);
        if (baseResult == null)
            return null;
        return (TransferConfirm) baseResult;
    }
}
