package com.fshows.umpay.bankchannel.model.transfer;

import com.fshows.umpay.sdk.request.MerchantBaseRequest;
import com.umpay.dto.UMFResponse;
import com.umpay.util.UMFUtil;
import lombok.Data;
import lombok.ToString;

/**
 * @author HEYUNHANG
 * @date 2023/3/28 15:50
 */
@ToString(callSuper = true)
@Data
public class TransferApply extends MerchantBaseRequest {

    private String notify_url;

    private String order_id;

    private String order_date;

    private String pay_acct_id;

    private String recv_acct_id;

    private String mer_trace;

    private String amount;

    private String remark;


    private String url = "/wxh/transfer/transferApply";


    @Override
    public String getRequestUrl() {
        return baseUrl + url;
    }

    @Override
    public TransferApply doRequest() throws Exception {
        UMFResponse.Message<TransferApply> response = UMFUtil.post(createAPIContext(), this, TransferApply.class);
        MerchantBaseRequest baseResult = convertResult(response, TransferApply.class);
        if (baseResult == null)
            return null;
        return (TransferApply) baseResult;
    }
}
