package com.fshows.umpay.bankchannel.model.sms;

import com.fshows.umpay.sdk.request.MerchantBaseRequest;
import com.umpay.dto.UMFResponse;
import com.umpay.util.UMFUtil;

/**
 * <p>
 * 获取手机验证码
 * </p>
 *
 * @author jzyan
 * @since 2023-03-09
 */
public class WxhSmsCode extends MerchantBaseRequest {
    private String url = "/wxh/sms/code";//请求服务

    /**
     * 商户订单号
     */
    private String order_id;
    /**
     * 商户订单时间
     */
    private String order_date;
    /**
     * 业务类型 1-转账短信验证，2-进件短信验证，3-授权短信验证
     */
    private String sms_type;

    @Override
    public String getRequestUrl() {
        return baseUrl + url;
    }

    public UMFResponse.Message doRequest2() throws Exception {
        return UMFUtil.post(createAPIContext(), this, WxhSmsCode.class);
    }

    public String getOrder_id() {
        return order_id;
    }

    public void setOrder_id(String order_id) {
        this.order_id = order_id;
    }

    public String getOrder_date() {
        return order_date;
    }

    public void setOrder_date(String order_date) {
        this.order_date = order_date;
    }

    public String getSms_type() {
        return sms_type;
    }

    public void setSms_type(String sms_type) {
        this.sms_type = sms_type;
    }

    @Override
    public String toString() {
        return "WxhSmsCodeReq{" +
                "order_id='" + order_id + '\'' +
                ", order_date='" + order_date + '\'' +
                ", sms_type='" + sms_type + '\'' +
                '}';
    }
}
