package com.fshows.umpay.bankchannel.model.register;

import com.fshows.umpay.sdk.request.MerchantBaseRequest;
import com.umpay.dto.UMFResponse;
import com.umpay.util.UMFUtil;

/**
 * <p>
 * 个人进件
 * </p>
 *
 * @author jzyan
 * @since 2023-03-09
 */
public class WxhRegisterPersonal extends MerchantBaseRequest {
    private String url = "/wxh/register/personal";//请求服务

    /**
     * 商户订单号
     */
    private String order_id;
    /**
     * 商户订单时间
     */
    private String order_date;
    /**
     * 用户姓名
     */
    private String name;
    /**
     * 身份证号
     */
    private String id_card;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 身份证正面图片media_id
     */
    private String id_card_front_media_id;
    /**
     * 身份证反面图片media_id
     */
    private String id_card_back_media_id;
    /**
     * 证件有效期
     */
    private String id_card_valid_date;
    /**
     * 银行卡卡号
     */
    private String bank_account;
    /**
     * 开户名称
     */
    private String bank_account_name;
    /**
     * 银行编码
     */
    private String bank_code;
    /**
     * 联行号
     */
    private String cnaps_code;

    /**
     * 返回值
     *
     * @return
     */
    private String order_state;
    private String audit_msg;

    @Override
    public String getRequestUrl() {
        return baseUrl + url;
    }

    public UMFResponse.Message doRequest2() throws Exception {
        return UMFUtil.post(createAPIContext(), this, WxhRegisterRes.class);
    }

    public String getOrder_id() {
        return order_id;
    }

    public void setOrder_id(String order_id) {
        this.order_id = order_id;
    }

    public String getOrder_date() {
        return order_date;
    }

    public void setOrder_date(String order_date) {
        this.order_date = order_date;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId_card() {
        return id_card;
    }

    public void setId_card(String id_card) {
        this.id_card = id_card;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getId_card_front_media_id() {
        return id_card_front_media_id;
    }

    public void setId_card_front_media_id(String id_card_front_media_id) {
        this.id_card_front_media_id = id_card_front_media_id;
    }

    public String getId_card_back_media_id() {
        return id_card_back_media_id;
    }

    public void setId_card_back_media_id(String id_card_back_media_id) {
        this.id_card_back_media_id = id_card_back_media_id;
    }

    public String getId_card_valid_date() {
        return id_card_valid_date;
    }

    public void setId_card_valid_date(String id_card_valid_date) {
        this.id_card_valid_date = id_card_valid_date;
    }

    public String getBank_account() {
        return bank_account;
    }

    public void setBank_account(String bank_account) {
        this.bank_account = bank_account;
    }

    public String getBank_account_name() {
        return bank_account_name;
    }

    public void setBank_account_name(String bank_account_name) {
        this.bank_account_name = bank_account_name;
    }

    public String getBank_code() {
        return bank_code;
    }

    public void setBank_code(String bank_code) {
        this.bank_code = bank_code;
    }

    public String getCnaps_code() {
        return cnaps_code;
    }

    public void setCnaps_code(String cnaps_code) {
        this.cnaps_code = cnaps_code;
    }

    public String getOrder_state() {
        return order_state;
    }

    public void setOrder_state(String order_state) {
        this.order_state = order_state;
    }

    public String getAudit_msg() {
        return audit_msg;
    }

    public void setAudit_msg(String audit_msg) {
        this.audit_msg = audit_msg;
    }

    @Override
    public String toString() {
        return "RegisterPersonalReq{" +
                "order_id='" + order_id + '\'' +
                ", order_date='" + order_date + '\'' +
                ", name='" + name + '\'' +
                ", id_card='" + id_card + '\'' +
                ", mobile='" + mobile + '\'' +
                ", id_card_front_media_id='" + id_card_front_media_id + '\'' +
                ", id_card_back_media_id='" + id_card_back_media_id + '\'' +
                ", id_card_valid_date='" + id_card_valid_date + '\'' +
                ", bank_account='" + bank_account + '\'' +
                ", bank_account_name='" + bank_account_name + '\'' +
                ", bank_code='" + bank_code + '\'' +
                ", cnaps_code='" + cnaps_code + '\'' +
                ", order_state='" + order_state + '\'' +
                ", audit_msg='" + audit_msg + '\'' +
                '}';
    }
}
