package com.fshows.umpay.bankchannel.model.register;

import com.fshows.umpay.sdk.request.MerchantBaseRequest;
import com.umpay.dto.UMFResponse;
import com.umpay.util.UMFUtil;

/**
 * <p>
 * 企业进件
 * </p>
 *
 * @author jzyan
 * @since 2023-03-09
 */
public class WxhRegisterEnterprise extends MerchantBaseRequest {
    private String url = "/wxh/register/enterprise";//请求服务

    /**
     * 商户订单号
     */
    private String order_id;
    /**
     * 商户订单时间
     */
    private String order_date;

    /**
     * 企业类型 2-个体，3-企业
     */
    private String org_type;
    /**
     * 商户简称
     */
    private String short_name;
    /**
     * 回调地址
     */
    private String notify_url;
    /**
     * 联系人邮箱 可以填法人邮箱
     */
    private String contact_email;
    /**
     * 营业执照信息
     */
    private License license;
    /**
     * 组织机构代码证
     */
    private OrganizationCert organization_cert;
    /**
     * 税务证
     */
    private TaxRegistrationCert tax_registration_cert;
    /**
     * 银行卡信息
     */
    private Bankcard bankcard;
    /**
     * 法人信息
     */
    private LegalPerson legal_person;

    @Override
    public String getRequestUrl() {
        return baseUrl + url;
    }

    public UMFResponse.Message doRequest2() throws Exception {
        return UMFUtil.post(createAPIContext(), this, WxhRegisterRes.class);
    }

    /**
     * 营业执照
     */
    public static class License {
        /**
         * 营业执照编号
         */
        private String license_no;
        /**
         * 营业执照公司名
         */
        private String license_name;
        /**
         * 营业执照注册地址
         */
        private String license_company_address;
        /**
         * 营业期限
         */
        private String license_valid_date;
        /**
         * 营业执照图片media_id
         */
        private String license_media_id;

        public String getLicense_no() {
            return license_no;
        }

        public void setLicense_no(String license_no) {
            this.license_no = license_no;
        }

        public String getLicense_name() {
            return license_name;
        }

        public void setLicense_name(String license_name) {
            this.license_name = license_name;
        }

        public String getLicense_company_address() {
            return license_company_address;
        }

        public void setLicense_company_address(String license_company_address) {
            this.license_company_address = license_company_address;
        }

        public String getLicense_valid_date() {
            return license_valid_date;
        }

        public void setLicense_valid_date(String license_valid_date) {
            this.license_valid_date = license_valid_date;
        }

        public String getLicense_media_id() {
            return license_media_id;
        }

        public void setLicense_media_id(String license_media_id) {
            this.license_media_id = license_media_id;
        }

        @Override
        public String toString() {
            return "License{" +
                    "license_no='" + license_no + '\'' +
                    ", license_name='" + license_name + '\'' +
                    ", license_company_address='" + license_company_address + '\'' +
                    ", license_valid_date='" + license_valid_date + '\'' +
                    ", license_media_id='" + license_media_id + '\'' +
                    '}';
        }
    }

    /**
     * 组织机构代码证
     */
    public static class OrganizationCert {
        private String organization_cert_no;
        private String organization_cert_valid_date;
        private String organization_cert_media_id;

        public String getOrganization_cert_no() {
            return organization_cert_no;
        }

        public void setOrganization_cert_no(String organization_cert_no) {
            this.organization_cert_no = organization_cert_no;
        }

        public String getOrganization_cert_valid_date() {
            return organization_cert_valid_date;
        }

        public void setOrganization_cert_valid_date(String organization_cert_valid_date) {
            this.organization_cert_valid_date = organization_cert_valid_date;
        }

        public String getOrganization_cert_media_id() {
            return organization_cert_media_id;
        }

        public void setOrganization_cert_media_id(String organization_cert_media_id) {
            this.organization_cert_media_id = organization_cert_media_id;
        }

        @Override
        public String toString() {
            return "OrganizationCert{" +
                    "organization_cert_no='" + organization_cert_no + '\'' +
                    ", organization_cert_valid_date='" + organization_cert_valid_date + '\'' +
                    ", organization_cert_media_id='" + organization_cert_media_id + '\'' +
                    '}';
        }
    }

    /**
     * 税务登记证
     */
    public static class TaxRegistrationCert {
        private String tax_certificate_cert_no;
        private String tax_registration_cert_media_id;

        public String getTax_certificate_cert_no() {
            return tax_certificate_cert_no;
        }

        public void setTax_certificate_cert_no(String tax_certificate_cert_no) {
            this.tax_certificate_cert_no = tax_certificate_cert_no;
        }

        public String getTax_registration_cert_media_id() {
            return tax_registration_cert_media_id;
        }

        public void setTax_registration_cert_media_id(String tax_registration_cert_media_id) {
            this.tax_registration_cert_media_id = tax_registration_cert_media_id;
        }

        @Override
        public String toString() {
            return "TaxRegistrationCert{" +
                    "tax_certificate_cert_no='" + tax_certificate_cert_no + '\'' +
                    ", tax_registration_cert_media_id='" + tax_registration_cert_media_id + '\'' +
                    '}';
        }
    }

    /**
     * 银行卡
     */
    public static class Bankcard {
        /**
         * 银行卡账户类型 1-对私账户，2-对公账户
         */
        private String bankcard_type;
        /**
         * 银行卡卡号
         */
        private String bank_account;
        /**
         * 开户名称
         */
        private String bank_account_name;
        /**
         * 银行编号
         */
        private String bank_code;
        /**
         * 联行号 对公必传
         */
        private String cnaps_code;

        public String getBankcard_type() {
            return bankcard_type;
        }

        public void setBankcard_type(String bankcard_type) {
            this.bankcard_type = bankcard_type;
        }

        public String getBank_account() {
            return bank_account;
        }

        public void setBank_account(String bank_account) {
            this.bank_account = bank_account;
        }

        public String getBank_account_name() {
            return bank_account_name;
        }

        public void setBank_account_name(String bank_account_name) {
            this.bank_account_name = bank_account_name;
        }

        public String getBank_code() {
            return bank_code;
        }

        public void setBank_code(String bank_code) {
            this.bank_code = bank_code;
        }

        public String getCnaps_code() {
            return cnaps_code;
        }

        public void setCnaps_code(String cnaps_code) {
            this.cnaps_code = cnaps_code;
        }

        @Override
        public String toString() {
            return "Bankcard{" +
                    "bankcard_type='" + bankcard_type + '\'' +
                    ", bank_account='" + bank_account + '\'' +
                    ", bank_account_name='" + bank_account_name + '\'' +
                    ", bank_code='" + bank_code + '\'' +
                    ", cnaps_code='" + cnaps_code + '\'' +
                    '}';
        }
    }

    /**
     * 法人
     */
    public static class LegalPerson {
        /**
         * 法人姓名
         */
        private String legal_name;
        /**
         * 法人证件号
         */
        private String legal_idcard;
        /**
         * 法人证件类型
         */
        private String legal_idcard_type;
        /**
         * 证件正面图片media_id
         */
        private String id_card_front_media_id;
        /**
         * 证件反面图片media_id
         */
        private String id_card_back_media_id;
        /**
         * 证件有效期
         */
        private String legal_idcard_valid_date;
        /**
         * 法人手机号
         */
        private String legal_mobile;

        public String getLegal_name() {
            return legal_name;
        }

        public void setLegal_name(String legal_name) {
            this.legal_name = legal_name;
        }

        public String getLegal_idcard() {
            return legal_idcard;
        }

        public void setLegal_idcard(String legal_idcard) {
            this.legal_idcard = legal_idcard;
        }

        public String getLegal_idcard_type() {
            return legal_idcard_type;
        }

        public void setLegal_idcard_type(String legal_idcard_type) {
            this.legal_idcard_type = legal_idcard_type;
        }

        public String getLegal_idcard_valid_date() {
            return legal_idcard_valid_date;
        }

        public void setLegal_idcard_valid_date(String legal_idcard_valid_date) {
            this.legal_idcard_valid_date = legal_idcard_valid_date;
        }

        public String getLegal_mobile() {
            return legal_mobile;
        }

        public void setLegal_mobile(String legal_mobile) {
            this.legal_mobile = legal_mobile;
        }

        public String getId_card_front_media_id() {
            return id_card_front_media_id;
        }

        public void setId_card_front_media_id(String id_card_front_media_id) {
            this.id_card_front_media_id = id_card_front_media_id;
        }

        public String getId_card_back_media_id() {
            return id_card_back_media_id;
        }

        public void setId_card_back_media_id(String id_card_back_media_id) {
            this.id_card_back_media_id = id_card_back_media_id;
        }

        @Override
        public String toString() {
            return "LegalPerson{" +
                    "legal_name='" + legal_name + '\'' +
                    ", legal_idcard='" + legal_idcard + '\'' +
                    ", legal_idcard_type='" + legal_idcard_type + '\'' +
                    ", id_card_front_media_id='" + id_card_front_media_id + '\'' +
                    ", id_card_back_media_id='" + id_card_back_media_id + '\'' +
                    ", legal_idcard_valid_date='" + legal_idcard_valid_date + '\'' +
                    ", legal_mobile='" + legal_mobile + '\'' +
                    '}';
        }
    }

    public String getOrder_id() {
        return order_id;
    }

    public void setOrder_id(String order_id) {
        this.order_id = order_id;
    }

    public String getOrder_date() {
        return order_date;
    }

    public void setOrder_date(String order_date) {
        this.order_date = order_date;
    }

    public String getOrg_type() {
        return org_type;
    }

    public void setOrg_type(String org_type) {
        this.org_type = org_type;
    }

    public String getShort_name() {
        return short_name;
    }

    public void setShort_name(String short_name) {
        this.short_name = short_name;
    }

    public License getLicense() {
        return license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public OrganizationCert getOrganization_cert() {
        return organization_cert;
    }

    public void setOrganization_cert(OrganizationCert organization_cert) {
        this.organization_cert = organization_cert;
    }

    public TaxRegistrationCert getTax_registration_cert() {
        return tax_registration_cert;
    }

    public void setTax_registration_cert(TaxRegistrationCert tax_registration_cert) {
        this.tax_registration_cert = tax_registration_cert;
    }

    public Bankcard getBankcard() {
        return bankcard;
    }

    public void setBankcard(Bankcard bankcard) {
        this.bankcard = bankcard;
    }

    public LegalPerson getLegal_person() {
        return legal_person;
    }

    public void setLegal_person(LegalPerson legal_person) {
        this.legal_person = legal_person;
    }

    public String getNotify_url() {
        return notify_url;
    }

    public void setNotify_url(String notify_url) {
        this.notify_url = notify_url;
    }

    public String getContact_email() {
        return contact_email;
    }

    public void setContact_email(String contact_email) {
        this.contact_email = contact_email;
    }

    @Override
    public String toString() {
        return "WxhRegisterEnterprise{" +
                "order_id='" + order_id + '\'' +
                ", order_date='" + order_date + '\'' +
                ", org_type='" + org_type + '\'' +
                ", short_name='" + short_name + '\'' +
                ", notify_url='" + notify_url + '\'' +
                ", contact_email='" + contact_email + '\'' +
                ", license=" + license +
                ", organization_cert=" + organization_cert +
                ", tax_registration_cert=" + tax_registration_cert +
                ", bankcard=" + bankcard +
                ", legal_person=" + legal_person +
                '}';
    }
}
