package com.fshows.umpay.bankchannel.model.grant;

import com.fshows.umpay.sdk.request.MerchantBaseRequest;
import com.umpay.dto.UMFResponse;
import com.umpay.util.UMFUtil;
import lombok.Data;
import lombok.ToString;

/**
 * @author HEYUNHANG
 * @date 2023/3/28 15:43
 */
@ToString(callSuper = true)
@Data
public class GrantConfirm extends MerchantBaseRequest {

    private String order_id;

    private String order_date;

    private String verify_code;

    private String url = "/wxh/grant/grantConfirm";


    @Override
    public String getRequestUrl() {
        return baseUrl + url;
    }

    @Override
    public GrantConfirm doRequest() throws Exception {
        UMFResponse.Message<GrantConfirm> response = UMFUtil.post(createAPIContext(), this, GrantConfirm.class);
        MerchantBaseRequest baseResult = convertResult(response, GrantConfirm.class);
        if (baseResult == null)
            return null;
        return (GrantConfirm) baseResult;
    }
}
