package com.fshows.umpay.bankchannel.model.grant;

import com.fshows.umpay.sdk.request.MerchantBaseRequest;
import com.umpay.dto.UMFResponse;
import com.umpay.util.UMFUtil;
import lombok.Data;
import lombok.ToString;

/**
 * @author HEYUNHANG
 * @date 2023/3/28 15:37
 */
@ToString(callSuper = true)
@Data
public class GrantApply extends MerchantBaseRequest {

    private String notify_url;

    private String order_id;

    private String order_date;

    private String mer_cust_id;

    private String name;

    private String id_card;

    private String mobile;

    private String url = "/wxh/grant/grantApply";


    @Override
    public String getRequestUrl() {
        return baseUrl + url;
    }

    @Override
    public GrantApply doRequest() throws Exception {
        UMFResponse.Message<GrantApply> response = UMFUtil.post(createAPIContext(), this, GrantApply.class);
        MerchantBaseRequest baseResult = convertResult(response, GrantApply.class);
        if (baseResult == null)
            return null;
        return (GrantApply) baseResult;
    }
}
