/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.bankchannel.enums;

import com.fshows.umpay.bankchannel.request.UmBankPersonalEntryQueryRequest;
import com.fshows.umpay.bankchannel.request.UmBankUploadImageRequest;
import com.fshows.umpay.bankchannel.request.funds.UmBankTradingQueryRequest;
import com.fshows.umpay.bankchannel.request.funds.UmBankTransferQueryRequest;
import com.fshows.umpay.bankchannel.request.funds.UmBankTransferRequest;
import com.fshows.umpay.bankchannel.request.funds.UmBankWithdrawQueryRequest;
import com.fshows.umpay.bankchannel.request.funds.UmBankWithdrawRequest;
import com.fshows.umpay.bankchannel.request.merchant.UmBankAccountQueryRequest;
import com.fshows.umpay.bankchannel.request.merchant.UmBankBindCardQueryRequest;
import com.fshows.umpay.bankchannel.request.merchant.UmBankBindCardRemoveRequest;
import com.fshows.umpay.bankchannel.request.merchant.UmBankBindCardRequest;
import com.fshows.umpay.bankchannel.request.merchant.UmBankDownloadElectronicReceiptRequest;
import com.fshows.umpay.bankchannel.request.merchant.UmBankDownloadStatementRequest;
import com.fshows.umpay.bankchannel.request.merchant.UmBankEnterpriseEntryRequest;
import com.fshows.umpay.bankchannel.request.merchant.UmBankEntryQueryRequest;
import com.fshows.umpay.bankchannel.request.merchant.UmBankPersonalEntryRequest;
import com.fshows.umpay.bankchannel.request.merchant.UmBankPersonalModifyRequest;
import com.fshows.umpay.bankchannel.response.UmBankUploadImageResponse;
import com.fshows.umpay.bankchannel.response.funds.UmBankTradingQueryResponse;
import com.fshows.umpay.bankchannel.response.funds.UmBankTransferQueryResponse;
import com.fshows.umpay.bankchannel.response.funds.UmBankTransferResponse;
import com.fshows.umpay.bankchannel.response.funds.UmBankWithdrawQueryResponse;
import com.fshows.umpay.bankchannel.response.funds.UmBankWithdrawalResponse;
import com.fshows.umpay.bankchannel.response.merchant.UmBankAccountQueryResponse;
import com.fshows.umpay.bankchannel.response.merchant.UmBankBindCardQueryResponse;
import com.fshows.umpay.bankchannel.response.merchant.UmBankBindCardRemoveResponse;
import com.fshows.umpay.bankchannel.response.merchant.UmBankBindCardResponse;
import com.fshows.umpay.bankchannel.response.merchant.UmBankDownloadElectronicReceiptResponse;
import com.fshows.umpay.bankchannel.response.merchant.UmBankDownloadStatementResponse;
import com.fshows.umpay.bankchannel.response.merchant.UmBankEnterpriseEntryResponse;
import com.fshows.umpay.bankchannel.response.merchant.UmBankEntryQueryResponse;
import com.fshows.umpay.bankchannel.response.merchant.UmBankPersonalEntryQueryResponse;
import com.fshows.umpay.bankchannel.response.merchant.UmBankPersonalEntryResponse;
import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import org.apache.commons.lang3.StringUtils;

/**
 * 联动云直通接口枚举
 *
 * @author liluqing
 * @version UmTradeApiEnum.java, v 0.1 2022-02-09 下午10:41 liluqing
 */
public enum UmBankChannelApiEnum implements UmpayApiDefinition {

    APPLY_TRANSFER(
            "转账",
            "/wxh/transfer/transferApply",
            UmBankTransferRequest.class,
            UmBankTransferResponse.class
    ),

    QUERY_TRANSFER(
            "转账查询",
            "/wxh/transfer/transferOrderQuery",
            UmBankTransferQueryRequest.class,
            UmBankTransferQueryResponse.class
    ),

    BALANCE_WITHDRAWAL(
            "余额提现",
            "/wxh/withdrawal/balanceWithdrawal",
            UmBankWithdrawRequest.class,
            UmBankWithdrawalResponse.class
    ),

    QUERY_WITHDRAWAL(
            "提现查询",
            "/wxh/withdrawal/orderQuery",
            UmBankWithdrawQueryRequest.class,
            UmBankWithdrawQueryResponse.class
    ),

    PERSONAL_ENTRY(
            "个人用户进件",
            "/wxh/register/personal",
            UmBankPersonalEntryRequest.class,
            UmBankPersonalEntryResponse.class
    ),
    PERSONAL_UPDATE(
            "个人信息修改",
            "/wxh/personal/modify",
            UmBankPersonalModifyRequest.class,
            UmBankPersonalEntryResponse.class
    ),
    PERSONAL_UPDATE_QUERY(
            "个人信息修改查询",
            "/wxh/personal/modify/query",
            UmBankPersonalEntryQueryRequest.class,
            UmBankPersonalEntryQueryResponse.class
    ),

    ENTERPRISE_ENTRY(
            "企业用户进件接口",
            "/wxh/register/enterprise",
            UmBankEnterpriseEntryRequest.class,
            UmBankEnterpriseEntryResponse.class
    ),
    QUERY_REGISTER(
            "开户状态查询接口",
            "/wxh/register/query",
            UmBankEntryQueryRequest.class,
            UmBankEntryQueryResponse.class
    ),
    QUERY_ACCOUNT(
            "电子账簿查询接口",
            "/wxh/account/accountQuery",
            UmBankAccountQueryRequest.class,
            UmBankAccountQueryResponse.class
    ),
    UPLOAD_IMAGE(
            "图片上传",
            "/wxh/file/upload",
            UmBankUploadImageRequest.class,
            UmBankUploadImageResponse.class
    ),

    TRADING_QUERY(
            "电子账簿流水查询",
            "/wxh/tradingQuery",
            UmBankTradingQueryRequest.class,
            UmBankTradingQueryResponse.class
    ),

    ADD_BIND_BANK_CARD(
            "企业新增绑卡",
            "/wxh/bindcard",
            UmBankBindCardRequest.class,
            UmBankBindCardResponse.class
    ),

    ADD_BIND_BANK_CARD_QUERY(
            "企业新增绑卡查询",
            "/wxh/bindcard/orderQuery",
            UmBankBindCardQueryRequest.class,
            UmBankBindCardQueryResponse.class
    ),

    REMOVE_BIND_BANK_CARD(
            "企业删除绑卡",
            "/wxh/unBindCard",
            UmBankBindCardRemoveRequest.class,
            UmBankBindCardRemoveResponse.class
    ),

    DOWNLOAD_ELECTRONIC_RECEIPT(
            "电子回单下载",
            "/wxh/file/electronicReceipt",
            UmBankDownloadElectronicReceiptRequest.class,
            UmBankDownloadElectronicReceiptResponse.class
    ),

    DOWNLOAD_STATEMENT(
            "对账单下载",
            "/wxh/trade/bill",
            UmBankDownloadStatementRequest.class,
            UmBankDownloadStatementResponse.class
    )
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口方法签名
     */
    private String value;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    UmBankChannelApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static UmBankChannelApiEnum getByValue(String value) {
        UmBankChannelApiEnum[] valueList = UmBankChannelApiEnum.values();
        for (UmBankChannelApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    /**
     * Getter method for property <tt>requestClass</tt>.
     *
     * @return property value of requestClass
     */
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}