/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant.wx;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.merchant.wx.UmpayWxApplymentCancelResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 微信实名认证-撤销申请单
 *
 * @author
 * @version UmpayWxApplymentCancelRequest.java, v 0.1 2022-03-16 16:12:19
 */
@Data
public class UmpayWxApplymentCancelRequest extends UmBizRequest<UmpayWxApplymentCancelResponse> {

    private static final long serialVersionUID = -2213838555156780485L;


    /**
     * 申请单号
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "applymentId长度不能超过64")
    private String applymentId;

    /**
     * 服务商申请单编号
     *
     * (特殊必填)
     */
    @Length(max = 128, message = "businessCode长度不能超过128")
    private String businessCode;

    @Override
    public Class<UmpayWxApplymentCancelResponse> getResponseClass() {
        return UmpayWxApplymentCancelResponse.class;
    }
}