/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.response.picture.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 图片信息
 *
 * @author liluqing
 * @version FilesBatchQueryDetailResponse.java, v 0.1 2022-03-16 15:23
 */
@Data
public class FilesBatchQueryDetailResponse implements Serializable {

    private static final long serialVersionUID = -2213838555773263013L;

    /**
     * 文件ID，系统内唯一
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "fileId长度不能超过32")
    private String fileId;

    /**
     * 上传文件URL
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 255, message = "fileUrl长度不能超过255")
    private String fileUrl;

    /**
     * 图片是否已使用：1-已使用; 0-未使用
     * <p>
     * (必填)
     */
    @NotNull
    private Integer isUse;

    /**
     * 图片状态：0-上传中; 1-上传成功; 2-上传失败
     * <p>
     * (必填)
     */
    @NotNull
    private Integer status;

    /**
     * 上传成功，或者返回上传失败的原因
     * <p>
     * (特殊必填)
     */
    @Length(max = 255, message = "failReason长度不能超过255")
    private String failReason;

    /**
     * 文件备注，图片批量上传接口中的备注原样返回
     * <p>
     * (选填)
     */
    @Length(max = 255, message = "memo长度不能超过255")
    private String memo;
}