/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.response.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 微信子商户号授权状态列表
 * 
 * @author liluqing
 * @version WxMerchantStateDetailResponse.java, v 0.1 2022-03-16 16:04
 */
@Data
public class WxMerchantStateDetailResponse implements Serializable {

    private static final long serialVersionUID = -2213838555773263013L;

    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻成功后由平台返回
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 微信子商户号，微信商户签约成功后返回
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "subMchId长度不能超过32")
    private String subMchId;

    /**
     * 微信子商户号的授权认证状态0-未授权；1-已授权示例:0
     *
     * (必填)
     */
    @NotNull
    private Integer state;

    /**
     * 授权状态描述示例：未授权
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "desc长度不能超过64")
    private String desc;

}