/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.terminal;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.terminal.UmpayTerminalBandQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * POS绑定状态查询
 *
 * @author
 * @version UmpayTerminalBandQueryRequest.java, v 0.1 2022-03-16 16:26:56
 */
@Data
public class UmpayTerminalBandQueryRequest extends UmBizRequest<UmpayTerminalBandQueryResponse> {

    private static final long serialVersionUID = -2213838555874782342L;


    /**
     * 商户ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 厂商编号厂商编号、终端型号、终端SN号、终端设备号4选一必填
     *
     * (特殊必填)
     */
    @Length(max = 3, message = "provId长度不能超过3")
    private String provId;

    /**
     * 终端型号厂商编号、终端型号、终端SN号、终端设备号4选一必填
     *
     * (特殊必填)
     */
    @Length(max = 4, message = "modelId长度不能超过4")
    private String modelId;

    /**
     * 终端SN号厂商编号、终端型号、终端SN号、终端设备号4选一必填
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "snNumber长度不能超过64")
    private String snNumber;

    /**
     * 终端设备号；厂商编号、终端型号、终端SN号、终端设备号4选一必填
     *
     * (选填)
     */
    @Length(max = 8, message = "terminalId长度不能超过8")
    private String terminalId;

    /**
     * 子商户号；
     *
     * (选填)
     */
    @Length(max = 32, message = "subMchId长度不能超过32")
    private String subMchId;

    @Override
    public Class<UmpayTerminalBandQueryResponse> getResponseClass() {
        return UmpayTerminalBandQueryResponse.class;
    }
}